#include "platform.h"

player * firstPlayer = NULL, *secondPlayer = NULL;

void platformBeast::go(command myCommand)
{
  switch(myCommand)
  {
  case goLeft : xMomentum = -moveIncrement; break;
  case goRight: xMomentum = moveIncrement; break;
  case jump   : yMomentum = ((mymap->mapData[mapX][mapY].myTerrainType == 1) && (squareY == FLOORHEIGHT)) ?
                  -jumpIncrement : yMomentum; break;
  }
}

void platformBeast::advance(void)
{
  if ((mymap->mapData[mapX][mapY].myTerrainType == 1)
     && (squareY + yMomentum >= FLOORHEIGHT))
  {
    remove();                   //so you can't go through floors
    squareY = FLOORHEIGHT;
    yMomentum = 0;
    put(mapX, mapY);
  }
  else
    yMomentum+= gravity;
  if (xMomentum || yMomentum)
    addCommand(scriptNode::fineMoveRel,0,0,xMomentum, yMomentum);
  else
  {
    if ((direction == factor::northeast) || (direction == factor::southeast))
      turn(factor::east);
    if ((direction == factor::northwest) || (direction == factor::southwest))
      turn(factor::west);
    addCommand(scriptNode::doNothing,0,0,0,0);
  }
  factor::advance();
  if (alignment < 0)
  {
    int hitMissile = 0;
    if (hit(firstPlayer))
      firstPlayer -> hitPoints -= damage;
    if (hitMissile = firstPlayer->hitWithMissile(this))
      hitPoints -= firstPlayer->myMissiles[hitMissile-1]->damage;
  }
  if (hitPoints <= 0)
    die();
}

void platformBeast::die(void)
{
  remove();
}

void missile::advance()
{
  platformBeast::advance();
  --range;
  if (range == 0)
  {
    remove();
    if (owningPlayer)
      owningPlayer->myMissiles[missileNumber] = NULL;
    delete this;
  }
}

void player::fireMissile(void)
{
  for (int missileCounter = 0; (myMissiles[missileCounter] != NULL) && (missileCounter < numMissiles); ++missileCounter);
  if (missileCounter == numMissiles)
    return;
  myMissiles[missileCounter] = missileGenerator(missileType);
  missile * newMissile = myMissiles[missileCounter];
  newMissile->direction = direction;
  newMissile->missileNumber = missileCounter;
  newMissile->mymap = mymap;
  switch (direction)
  {
    case factor::east:
    case factor::southeast:
    case factor::northeast: newMissile->xMomentum = moveIncrement; break;
    case factor::west:
    case factor::southwest:
    case factor::northwest: newMissile->xMomentum = -moveIncrement; break;
  }
  newMissile->squareX = squareX;
  newMissile->squareY = squareY;
  newMissile->put(mapX, mapY);
}

int player::hitWithMissile(platformBeast * target)
{
  for (int missileCounter = 0; missileCounter < numMissiles; ++missileCounter)
    if (myMissiles[missileCounter])
      if (myMissiles[missileCounter]->hit(target))
        return missileCounter + 1;  //so zero is "no hit"
  return 0;
}

void crawler::advance(void)
{
  if (!(targetTerrain() & FLOOR))
    direction = ((direction == factor::east) ? factor::west : factor::east);
  go((direction == factor::east) ? platformBeast::goRight : platformBeast::goLeft);
  platformBeast::advance();
}

