#ifndef EVENT.H
#include "fevent.h"
#endif


void fevent::advance()
{
  if (thisLine == NULL)
    addCommand(scriptNode::turn, direction,0,0,0);
  factor::advance();
  if (thisFrame == directionIcons[direction])
    {
    if (spawningActor == NULL)
      remove();			//destroy this copy of the event
    else
       (spawningActor->spawnedActor = NULL);
    delete(this);		//when it's done showing!
    }
}

void fevent::addAt(int x, int y, int sqx, int sqy) //create a copy of this
{						  //event and put it on
  fevent * new_event = new fevent;		  //the map.  It's destroyed
  if (new_event == NULL) return;
  new_event->mapX = x;				  //when its show is over!
  new_event->mapY = y;
  new_event->squareX = sqx;
  new_event->squareY = sqy;
  new_event->mymap = mymap;
  new_event->turn(direction);
  new_event->assignFevent(myIconNumber, factor::eightFace);
  new_event->spawningActor = NULL;
  new_event->spawnedActor = NULL;
  new_event->put(x, y);
}

directionTable * fevent::feventTable = new directionTable[MAX_ICONS];

void fevent::loadFevent(int position, char * special, char * sw, char * s,
			char * se, char * w, char * center, char * e,
			char * nw, char * n, char * ne, yakLib * myYakLib, icon::flagType flags)
{
  feventTable[position][factor::special].addAll(special, flags, myYakLib);
  feventTable[position][factor::southwest].addAll(sw, flags, myYakLib);
  feventTable[position][factor::south].addAll(s, flags, myYakLib);
  feventTable[position][factor::southeast].addAll(se, flags, myYakLib);
  feventTable[position][factor::west].addAll(w, flags, myYakLib);
  feventTable[position][factor::center].addAll(center, flags, myYakLib);
  feventTable[position][factor::east].addAll(e, flags, myYakLib);
  feventTable[position][factor::northwest].addAll(nw, flags, myYakLib);
  feventTable[position][factor::north].addAll(n, flags, myYakLib);
  feventTable[position][factor::northeast].addAll(ne, flags, myYakLib);
}


void fevent::assignFevent(int iconNumber, int mode, byte identity)
{
  myIdentity = identity;
  if (myIdentity == 255)
    myIdentity = iconNumber;
  myIconNumber = iconNumber;
  for (int counter = 0; counter < 10; ++counter)
    directionIcons[counter] = feventTable[iconNumber][counter].firstFrame;
  switch (mode)
  {
    case factor::eightFace:	break;
    case factor::oneFace:	for (counter = 1; counter < 10; ++counter)
			  directionIcons[counter] = feventTable[iconNumber][center].firstFrame;
			break;
    case factor::twoFace:	directionIcons[factor::north] = feventTable[iconNumber][center].firstFrame;
			directionIcons[factor::south] = feventTable[iconNumber][center].firstFrame;
    case factor::fourFace:	directionIcons[factor::northwest] = feventTable[iconNumber][west].firstFrame;
			directionIcons[factor::southwest] = feventTable[iconNumber][west].firstFrame;
			directionIcons[factor::northeast] = feventTable[iconNumber][east].firstFrame;
			directionIcons[factor::southeast] = feventTable[iconNumber][east].firstFrame;
			break;
  }
  for (counter = 0; counter < 10; ++counter)
    if (directionIcons[counter] == NULL)  // if it's not loaded, look @ center
      directionIcons[counter] = feventTable[iconNumber][center].firstFrame;
  if (direction > 10)
    direction = 5;
  thisFrame = directionIcons[direction];
}
