/* --------------------------------- device.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Top level for display-device drivers
*/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include "fly.h"

extern struct GrDriver *GrDrivers[];

extern int FAR
GrPrintf (const char *fmt, ...)
{
	va_list	ap;
	int	i;
	char	*p;
	static char _Gbuf[256];

	va_start (ap, fmt);
	i = vsprintf (_Gbuf, fmt, ap);
	va_end (ap);

	for (p = _Gbuf; *p; ++p)
		Gr->TextPut (*p);
	sys_poll ();			/* text is often slow */
	return (i);
}

extern int FAR
GrNote (const char *fmt, ...)
{
	va_list	ap;
	int	i;
	char	*p;
	static char _Gbuf[256];

	va_start (ap, fmt);
	i = vsprintf (_Gbuf, fmt, ap);
	va_end (ap);

	if (st.flags & SF_INTERACTIVE) {
		Gr->PushTextPos ();
		Gr->SetTextPos (2, 1);
	}

	for (p = _Gbuf; *p; ++p)
		Gr->TextPut (*p);

	if (st.flags & SF_INTERACTIVE)
		Gr->PopTextPos ();

	sys_poll ();			/* text is often slow */
	return (i);
}

extern DEVICE * FAR
devices_select (char *dname)
{
	int	xmode;
	char	*p;
	DEVICE	*dev;

	if (vm_read ())
		return (0);

	if (dname == 0)			/* return default */
		return (Gr->devices);

	xmode = 0;
	p = strchr (dname, '=');
	if (p) {		/* "xx=dname" */
		if (1 != sscanf (dname, "%x=", &xmode))
			return (0);
		dname = p+1;
	}

	for (dev = Gr->devices; dev; dev = dev->next)
		if (!stricmp (dev->name, dname)) {
			if (xmode)
				dev->mode = xmode;
			return (dev);
		}
	return (0);
}

#if 0
extern DEVICE * FAR
devices_select_old (char *dname)
{
	int	i, xmode;
	char	*p;

	if (dname == 0)			/* return default */
		return (Gr->devices);

	xmode = 0;
	p = strchr (dname, '=');
	if (p) {		/* "xx=dname" */
		if (1 != sscanf (dname, "%x=", &xmode))
			return (0);
		dname = p+1;
	}

	for (i = 0; Gr->devices[i].name; ++i)
		if (!stricmp (Gr->devices[i].name, dname)) {
			if (xmode)
				Gr->devices[i].mode = xmode;
			return (&Gr->devices[i]);
		}
	return (0);
}
#endif

extern struct GrDriver *FAR
devices_init (char *name)
{
	struct GrDriver	**p;

	p = GrDrivers;
	if (name)
		for (; *p; ++p)
			if (!stricmp ((*p)->name, name))
				break;
	return (*p);
}

extern void FAR
devices_term (void)
{
	if (!Gr)
		return;

	vm_free ();
}
