/* --------------------------------- listmac.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* list macro file.
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "fly.h"

struct key_name {
	char	*name;
	int	key;
};

static struct key_name key_name[] = {
	{"UP",		'2'},
	{"DOWN",	'8'},
	{"LEFT_TURN",	'4'},
	{"RIGHT_TURN",	'6'},
	{"STABLE",	'5'},
	{"RESET_ROLL",	'7'},
	{"LEVEL",	K_PGUP},
	{"ORIGIN",	K_PGDN},
	{"POWER_UP",	'9'},
	{"POWER_DOWN",	'3'},
	{"POWER_0",	'0'},
	{"POWER_100",	'1'},
	{"POWER_AB",	'.'},
	{"FIRE",	K_F1},
	{"FRUDLEFT",	K_F2},
	{"FRUDCNTR",	K_F3},
	{"FRUDRITE",	K_F4},
	{"ZOOMIN",	K_F5},
	{"ZOOMOUT",	K_F6},
	{"MACRECORD",	K_F7},
	{"MACPLAY",	K_F8},
	{"F9",		K_F9},
	{"F10",		K_F10},
	{"F11",		K_F12},
	{"F12",		K_F11},

	{"XUP",		K_UP},
	{"XDOWN",	K_DOWN},
	{"XLEFT",	K_LEFT},
	{"XRIGHT",	K_RIGHT},

	{"YUP",		(K_UP	| K_ALT)},
	{"YDOWN",	(K_DOWN	| K_ALT)},
	{"YLEFT",	(K_LEFT	| K_ALT)},
	{"YRIGHT",	(K_RIGHT| K_ALT)},

	{"ZUP",		(K_UP	| K_CTRL)},
	{"ZDOWN",	(K_DOWN	| K_CTRL)},
	{"ZLEFT",	(K_LEFT	| K_CTRL)},
	{"ZRIGHT",	(K_RIGHT| K_CTRL)},

	{"CR",		'\r'},
	{"NL",		'\n'},
	{"TAB",		'\t'},
	{"ESC",		K_ESC},
	{"DEL",		K_DEL},
	{"RUBOUT",	K_RUBOUT},
	{"HOME",	K_HOME},
	{"END",		K_END},
	{"CENTER-5",	K_CENTER},
	{"INS",		K_INS},

	{"C-@",		 0},
	{"C-a",		 1},
	{"C-b",		 2},
	{"C-c",		 3},
	{"C-d",		 4},
	{"C-e",		 5},
	{"C-f",		 6},
	{"C-g",		 7},
	{"C-h",		 8},
	{"C-i",		 9},
	{"C-j",		10},
	{"C-k",		11},
	{"C-l",		12},
	{"C-m",		13},
	{"C-n",		14},
	{"C-o",		15},
	{"C-p",		16},
	{"C-q",		17},
	{"C-r",		18},
	{"C-s",		19},
	{"C-t",		20},
	{"C-u",		21},
	{"C-v",		22},
	{"C-w",		23},
	{"C-x",		24},
	{"C-y",		25},
	{"C-z",		26},
{0,0}};

static int
read_short (int *i, FILE *f)
{
	int	n;

	n = fgetc (f);
	if (ferror (f) || feof (f))
		return (0);
	n = (n<<8) + fgetc (f);
	if (ferror (f) || feof (f))
		return (1);
	*i = n;
	return (2);
}

static void
show_key (int key)
{
	int	i, shifts, naked;
	char	shift[6];

	shifts = key & 0xff00;
	naked  = key & 0x00ff;

	shift[0] = (char)((K_ALT     & shifts) ? 'A' : '-');
	shift[1] = (char)((K_CTRL    & shifts) ? 'C' : '-');
	shift[2] = (char)((K_SHIFT   & shifts) ? 'S' : '-');
	shift[3] = (char)((K_QUOTE   & shifts) ? 'Q' : '-');
	shift[4] = (char)((K_SPECIAL & shifts) ? 'P' : '-');
	shift[5] =  (char)'\0';

	printf (" %s ", shift);

	if (isprint (naked))
		printf ("%c    ", naked);
	else
		printf ("[%3u]", naked);

	for (i = 0; key_name[i].name; ++i) {
		if (key_name[i].key == key) {
			printf (" %s", key_name[i].name);
			break;
		}
	}
}

int
main (int argc, char *argv[])
{
	int	i, j, t, len;
	FILE	*mac;
	char	*mname;

	if (argc < 2 || !(mname = argv[1]))
		mname = "fly.mac";
	mac = fopen (mname, RBMODE);
	if (!mac) {
		printf ("open '%s' failed", mname);
		return (1);
	}

	for (i = 0;; ++i) {
		if (2 != read_short (&t, mac))
			break;
		if (2 != read_short (&len, mac)) {
			printf ("read '%s' failed (1)", mname);
			goto ret;
		}
		show_key (t);
		printf (" %u", len);
		printf ("\n");
		for (j = 0; j < len; ++j) {
			if (2 != read_short (&t, mac)) {
				printf ("read '%s' failed (2)", mname);
				goto ret;
			}
			printf ("      ");
			show_key (t);
			printf ("\n");
		}
	}
	if (!feof (mac))
		printf ("read '%s' failed (3)", mname);
ret:
	fclose (mac);
	exit (0);
}
