/* --------------------------------- mouse.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the mouse as a pointing device.
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "fly.h"

#define PO	p->opt

static int	nbuttons = 2;
static int	speedx = 2;
static int	speedy = 2;

static int FAR
cal (POINTER *p)
{
	union REGS	rg;		/* cpu register for use of DOS calls */

	rg.x.ax = 4;			/* set mouse cursor position */
	rg.x.cx = 100 << 3;		/* middle col */
	rg.x.dx = 100 << 3;		/* middle row */
	int86(0x33, &rg, &rg);
	p->a[PO[1]] = p->a[PO[3]] = 0;
	p->l[PO[1]] = p->l[PO[3]] = 0;
	return (0);
}

static int FAR
init (POINTER *p)
{
	union REGS	rg;		/* cpu register for use of DOS calls */
	struct SREGS segreg;		/* cpu segment registers	     */
	long		miaddr;		/* mouse interupt routine address */

	p->flags = 0;

	/* check if the mouse drive exists first */
	rg.x.ax = 0x3533;		/* look at the interrupt 33 address */
	int86x(0x21, &rg, &rg, &segreg);
	miaddr = (((long)segreg.es) << 16) + (long)rg.x.bx;
	if (miaddr == 0 || *(char FAR *)miaddr == 0xcf)
		return (1);

	/* and then check for the mouse itself */
	rg.x.ax = 0;			/* mouse status flag */
	int86(0x33, &rg, &rg);		/* check for the mouse interupt */
	if (rg.x.ax == 0)
		return (2);
	p->flags |= PF_PRESENT;
	nbuttons = rg.x.bx;

#if 0
	/* and set its attributes */
	rg.x.ax = 10;			/* set text cursor */
	rg.x.bx = 0;			/* software text cursor please */
	rg.x.cx = 0x77ff;		/* screen mask */
	rg.x.dx = 0x7700;		/* cursor mask */
	int86(0x33, &rg, &rg);
#endif

	/* set number of cols for mouse */
	rg.x.ax = 7;			/* set min/max horizontal position */
	rg.x.cx = 0;			/* start at 0 */
	rg.x.dx = 200 << 3;	/* end at the end */
	int86(0x33, &rg, &rg);

	/* set number of vertical rows for mouse */
	rg.x.ax = 8;			/* set min/max vertical position */
	rg.x.cx = 0;			/* start at 0 */
	rg.x.dx = 200 << 3;	/* end at the end */
	int86(0x33, &rg, &rg);

	/* set mouse speed */
	rg.x.ax = 15;
	rg.x.cx = (PO[6] ? (1<<PO[6])/2 : speedx);
	rg.x.dx = (PO[7] ? (1<<PO[7])/2 : speedy);
	int86(0x33, &rg, &rg);

	/* ??? */
	rg.x.ax = 4;
	rg.x.cx = 100;
	rg.x.dx = 100;
	int86(0x33, &rg, &rg);

	/* get it in the middle */
	cal (p);

#if 0
	/* turn the mouse cursor on */
	rg.x.ax = 1;			/* Show Cursor */
	int86(0x33, &rg, &rg);

	/* turn the mouse cursor back off */
	rg.x.ax = 2;			/* Hide Cursor */
	int86(0x33, &rg, &rg);
#endif
	p->flags |= PF_INITED;
	return (0);
}

static void FAR
term (POINTER *p)
{
	p->flags = 0;
}

static int FAR
read (POINTER *p)
{
	union REGS	rg;		/* cpu register for use of DOS calls */

	/* check to see if any mouse buttons are different */
	rg.x.ax = 3;	/* Get button status and mouse position */
	int86(0x33, &rg, &rg);
	p->a[PO[3]] = (rg.x.dx >> 3) - 100;		/* x */
	p->a[PO[3]] *=  PO[2];
	p->a[PO[1]] = (rg.x.cx >> 3) - 100;		/* y */
	p->a[PO[1]] *=  -PO[0];
	p->b[PO[4]] += (rg.x.bx & 0x02) != 0;	/* right button */
	p->b[PO[5]] += (rg.x.bx & 0x01) != 0;	/* left button */
	return (0);
}

extern struct PtrDriver PtrMouse = {
	"MOUSE",
	0,
	init,
	term,
	cal,
	cal,			/* center */
	read,
	std_key
};
