/* --------------------------------- config.h ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* System dependent configuration information: UNIX
*/

#include <string.h>

#include "keymap.h"

#define	INIFILE	"fly.ini"	/* name of ini file */
#define	MACFILE	"fly.mac"	/* name of mac file */
#define	VMDFILE	"fly.vmd"	/* name of video modes file */
#define	LOGFILE	"fly.log"	/* name of log file */
#define	RTMODE	"r"		/* fopen file mode */
#define	WTMODE	"w"		/* fopen file mode */
#define	ATMODE	"a"		/* fopen file mode */
#define	RBMODE	"r"		/* fopen file mode */
#define	WBMODE	"w"		/* fopen file mode */
#define	ABMODE	"a"		/* fopen file mode */
#define	DIRSEP	"/"		/* directory separator */

#define	FAR
#define NEAR
#define FASTCALL

#define C_MAIN	main

#ifdef LINUX
#define NEED_STRICMP
#endif

#ifdef SUN
#include <malloc.h>
#endif

#ifdef SCO
#define NEED_STRICMP
#endif

#ifdef NEED_STRICMP
extern int stricmp (const char *a, const char *b);
extern int strnicmp (const char *a, const char *b, int n);
#endif
