(*  .....................................................................  *)
(*  :	file    	:  MYNESDEF.PAS                                 :  *)
(*  :  	contents	:  the types and constants for MYNES!		:  *)
(*  :	last update	:  30-JUN-93                                    :  *)
(*  :...................:...............................................:  *)

CONST	HOF_NAME_LEN = 8;
	HOF_SIZE     = 8;
        HOF_FILENAME = 'MYNES!.HOF';

TYPE    HOF_ENTRY_TYPE= RECORD
        			HiScore : WORD;
                                Name  	: STRING[HOF_NAME_LEN];
				Day     : WORD;
                                Month   : WORD;
                                Year	: WORD;
			END;  (* HOF_ENTRY_TYPE *)

	HOF_ARRAY_TYPE= ARRAY[1..8] OF HOF_ENTRY_TYPE;

        DISK_FILE_TYPE= RECORD
				HOF		: HOF_ARRAY_TYPE;
                                SoundIsOn,
                                LookIsPL	: BOOLEAN;
                                Level,
                                Speed		: BYTE;
			END;  (* DISK_FILE_TYPE *)

        (*  DEMO_START is a special situation ... the computer has to find
	    his first move, he cannot use the old reveal/mark-lists.
	    DEMO_START is switched to DEMO after the computer's move. *)
        STATUS_TYPE   = (TITLE,				(* title sequence *)
			 PLAY, DEMO_START, DEMO,	(* starting/game status *)
        		 BLASTED, WON, TIMEOUT,		(* game over status *)
			 QUIT);	  (* is both, game over and starting status *)

	FIELD_TYPE    =  ARRAY [COL_ROW_TYPE, COL_ROW_TYPE] OF CONTENTS_TYPE;


CONST   MONTHS : ARRAY[1..12] OF STRING[3] =
		('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
		 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

	FIRSTSPEED	= 1;
        LASTSPEED	= 5;
        (*  SPEED_FACTOR * scene.TimeLimit = actual_time_limit_for_game
            the SPEED_FACTOR is the time one game_minute lasts ...
            Speed       :  slow  fair  fast  awkward  ridiculous
            Factor      :  100%   75%   50%    33%      25%
	    Game-minute :   60s   45s   30s    20s      15s             *)
        SPEED_FACTOR	: ARRAY[FIRSTSPEED..LASTSPEED] OF WORD =
		(60,45,30,20,15);
        SPEEDSTR : ARRAY[FIRSTSPEED..LASTSPEED] OF STRING[10] =
        	('SLOW', 'FAIR', 'FAST', 'AWKWARD', 'RIDICULOUS');

	MAX_MINES	= 200;		(*  max. no of MINES, for explode *)

        SLOW_DIM	= TRUE;         	(* modes for dimming-speed *)
        FAST_DIM	= NOT(SLOW_DIM);


        CHECK_TIME      = 200;  (* speed-test takes CHECK_TIME/100 secs *)

        OPT_DIM_TIME	= 300;	(* msecs for dimming *)

	(* DIM_DELAY, DIM_STEP regulate dimming-speed *)
        DIM_DELAY	: WORD = 0;
        DIM_STEP	: WORD = 2;

	(*  the array containing the level-data  *)
	FIRSTLEVEL	= 1;
        LASTLEVEL	= 8;
        (* TimeLimit is in game-minutes *)
	Scene_ARRAY	: ARRAY[FIRSTLEVEL..LASTLEVEL] OF SCENE_TYPE =
		(  (NumCols: 12; NumRows: 8;
                    Size: (x: 50;  y: 50);
                    Origin: (x: 14; y: 7);
                    NumMines: 12;
	            TimeLimit:  3),	        (*   LEVEL   1  *)
		   (NumCols: 15; NumRows: 10;
                    Size: (x: 40;  y: 39);
                    Origin: (x: 13; y: 11);
                    NumMines: 20;
	            TimeLimit:  5),	        (*   LEVEL   2  *)
		   (NumCols: 20; NumRows: 13;
                    Size: (x: 30;  y: 30);
                    Origin: (x: 10; y: 10);
                    NumMines: 40;
	            TimeLimit: 10),          	(*   LEVEL   3  *)
		   (NumCols: 25; NumRows: 16;
                    Size: (x: 24;  y: 24);
                    Origin: (x: 8; y: 11);
                    NumMines: 60;
	            TimeLimit:  15),          	(*   LEVEL   4  *)
		   (NumCols: 28; NumRows: 18;
                    Size: (x: 21;  y: 21);
                    Origin: (x: 12; y: 13);
                    NumMines: 75;
	            TimeLimit:  18),          	(*   LEVEL   5  *)
       		   (NumCols: 31; NumRows: 21;
                    Size: (x: 19;  y: 18);
                    Origin: (x:10; y: 12);
                    NumMines: 100;
	            TimeLimit:  25),          	(*   LEVEL   6  *)
       		   (NumCols: 36; NumRows: 24;
                    Size: (x: 16; y: 16);
                    Origin: (x:14; y: 8);
                    NumMines: 135;
	            TimeLimit:  33),          	(*   LEVEL   7  *)
       		   (NumCols: 41; NumRows: 29;
                    Size: (x: 14;  y: 13);
                    Origin: (x: 13; y: 9);
                    NumMines: 190;
	            TimeLimit:  45)          	(*   LEVEL   8  *)
		);

        HOF_DEFAULT : HOF_ENTRY_TYPE =
        	(HiScore : 0; Name : ' @ Mac @'; Day : 30; Month : 8; Year : 92);

        TITLE_WAIT	= 15;	(* secs to wait in show_title *)

        LEVEL_GAD_Y     = 190;	(* the y-coordinates for the title-gadgets *)
        SPEED_GAD_Y	= LEVEL_GAD_Y + 57;
        TITLE_GAD_Y	= LEVEL_GAD_Y + 100;
        INSTRUCTIONS_Y  = LEVEL_GAD_Y + 132;

        START_LEVEL	= FIRSTLEVEL;	(* the start setting *)
        START_SPEED	= 1;

	COLBAR_HEIGHT	= 11;
        COLBAR_LEN	= 500;
	TIME_BAR	: COORDS_TYPE = (x: 56; y: 432);
        DONE_BAR	: COORDS_TYPE = (x: 56; y: 455);
        MIDDLE_X	: WORD = 319;
	(* half the x resolution, is re-computed in initialize() *)

VAR	playfield	: FIELD_TYPE;
        GameStatus	: STATUS_TYPE;
        play_tile	: TILE_TYPE;

        SoundIsON,
        LookIsPL,
	HOFexists 	: BOOLEAN;

        TITLE_DEMO_GADGET,
        TITLE_QUIT_GADGET,
        TITLE_START_GADGET,
        TITLE_MUSIC_GADGET,
        TITLE_LOOK_GADGET,
        TITLE_HOF_GADGET,
        GAME_DEMO_GADGET,
        GAME_QUIT_GADGET,
        GAME_PAUSE_GADGET : GADGET_TYPE;

        LEVEL_GAD	: ARRAY[FIRSTLEVEL..LASTLEVEL] OF GADGET_TYPE;
        SPEED_GAD	: ARRAY[1..5] OF GADGET_TYPE;
        PLAYTIMER	: TIMER_TYPE;
        Score,
	Speed,
        Level,
        MarkedTiles,                    (* no. of tiles marked *)
        Tiles_left,			(* no. of tiles not yet revealed *)
	TilesToReveal	: WORD;		(* tiles to reveal during game *)
	MaxTileSize 	: LONGINT;
        LeastCol	: COL_ROW_TYPE;
        ComputerPlayed,           	(* need them to decide whether it *)
        ManPlayed	: BOOLEAN;	(*  was a demo, demo/play or play *)
	OldExitProc	: POINTER;
        HallOfFame	: HOF_ARRAY_TYPE;
        HOF_PathName    : STRING;
