UNIT	TIMER;		(*  by  Marc Palms, 5.1.93  *)
INTERFACE
 TYPE	TIMER_TYPE = OBJECT
        		Stopped   : BOOLEAN;
			TimerEnd,
			Time_left : LONGINT;
	           	PROCEDURE  init(time : LONGINT);
			FUNCTION   read : LONGINT;
			PROCEDURE  restart;
			PROCEDURE  stop;
		     END;  (*  TIMER_TYPE  *)
IMPLEMENTATION
 USES	DOS;	(*  fr GetDate, GetTime  *)

 FUNCTION  get_act_time : LONGINT;
 (*  errechnet aktuelle Systemzeit (in Sek. seit 1.1.1980, 00:00)  *)
  VAR	ye, mo, da, ho, mi, se, dummy : WORD;
  BEGIN
    GetDate(ye, mo, da, dummy);  GetTime(ho, mi, se, dummy);
    get_act_time :=
      ((((LONGINT(ye - 1980)*12 +mo)*31 +da)*24 +ho)*60 +mi)*60 +se;
  END;  (*  get_act_time  *)

 (*  ----------  TIMER_TYPE-Methoden  ----------  *)
 PROCEDURE  TIMER_TYPE.init(time : LONGINT);
 (*  initialisiert und startet einen Timer mit 'time' Sekunden  *)
  BEGIN
    Stopped   := FALSE;
    Time_left := time;  TimerEnd := get_act_time + time;
  END;	(*  TIMER_TYPE.init  *)

 FUNCTION  TIMER_TYPE.read : LONGINT;  (*  gibt die Restzeit zurck  *)
  BEGIN
    IF  (Stopped)  THEN  read := Time_left   (*  Zeit beim Stoppen  *)
    		   ELSE  read := TimerEnd - get_act_time;
  END;	(*  TIMER_TYPE.read  *)

 PROCEDURE  TIMER_TYPE.restart;  (*  startet gestoppten Timer wieder  *)
  BEGIN
    IF  (Stopped)  THEN  TimerEnd := get_act_time + Time_left;
    Stopped := FALSE;
  END;	(*  TIMER_TYPE.restart  *)

 PROCEDURE  TIMER_TYPE.stop;  (*  stoppt den Timer  *)
  BEGIN
    IF  NOT(Stopped)  THEN  Time_left := TimerEnd - get_act_time;
    Stopped := TRUE;
  END;	(*  TIMER_TYPE.stop  *)
END.  (*  UNIT TIMER  *)
