/* FILE.C -- File-, Buffer-, and System-Oriented Commands

	Written July 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

#if defined(MSDOS)
#include <time.h>
#endif

char *getenv();

void F_FPathOpen_DirSep();	/* char *name */

/* ------------------------------------------------------------ */

/* Move to the begining of the buffer. */

void
FBufBeg()
	{
	BMarkToPoint(mark);
	BMoveToStart();
	while (--uarg > 0) SearchNLF();
	}


/* ------------------------------------------------------------ */

/* Delete the current buffer. */

void
FBufDel()
	{
	struct buffer *savebuf = cbuf;
	struct window *wptr;

	uarg = 0;
	if (!IS_SYS(cbuf->fname) && BIsMod(cbuf) &&
		 KAsk("Delete modified buffer?") != 'Y')
		return;

	FBufPrev();
	if (num_windows > 1) {
		wptr = (cwin == &windows[0]) ? &windows[1] : &windows[0];
		if (savebuf == BMarkBuf(wptr->sstart)) DWindOne();
		}
	BBufDelete(savebuf);
	DScreenRange();
	}


/* ------------------------------------------------------------ */

/* Move to the end of the buffer. */

void
FBufEnd()
	{
	if (isuarg)
		FBufBeg();
	else	{
		BMarkToPoint(mark);
		BMoveToEnd();
		}
	}


/* ------------------------------------------------------------ */

/* Display a buffer list. */

void
FBufList()
	{
	char buf[LINEBUFFSIZE];
	struct buffer *bptr;

	if (!FMakeSys(SYS_BUFFLIST, TRUE)) return;

	for (bptr = cbuf + 1; bptr != cbuf; bptr++) {
		if (bptr >= &buffers[NUMBUFFERS]) bptr = buffers;
		if (!BIsFree(bptr) &&
			 (isuarg || !IS_SYS(bptr->fname))) {
			xsprintf(buf, "%l	%s%s\n",
				BGetLength(bptr),
				BIsMod(bptr) ? "*" : " ",
				bptr->fname);
			BInsStr(buf);
			}
		}
	BMoveToStart();
	DWindSwap();
	}


/* ------------------------------------------------------------ */

/* Switch to the next buffer in the ring. */

void
FBufNext()
	{
	struct buffer *bptr;

	uarg = 0;
	for (bptr = cbuf + 1; bptr != cbuf; bptr++) {
		if (bptr >= &buffers[NUMBUFFERS]) bptr = buffers;
		if (BIsFree(bptr)) continue;
		if (!isuarg && IS_SYS(bptr->fname)) continue;
		break;
		}
	BBufGoto(bptr);
	}


/* ------------------------------------------------------------ */

/* Switch to the previous buffer in the ring. */

void
FBufPrev()
	{
	struct buffer *bptr;

	uarg = 0;
	for (bptr = cbuf; 1; ) {
		if (bptr == buffers) bptr = &buffers[NUMBUFFERS];
		bptr--;
		if (bptr == cbuf) break;

		if (BIsFree(bptr)) continue;
		if (!isuarg && IS_SYS(bptr->fname)) continue;
		break;
		}
	BBufGoto(bptr);
	}


/* ------------------------------------------------------------ */

/* Execute a shell command. */

#if !defined(NOEXEC)
void
FCommand()
	{
	char cmd_line[LINEBUFFSIZE];

	uarg = 0;
	*cmd_line = NUL;
	if (KGetStr("Command Line", cmd_line, LINEBUFFSIZE) != 'Y') return;

	TSetPoint(TMaxRow() - 1, 0);
	TCLEOL();
	TFini();

	system(cmd_line);

	xprintf("[Hit <CR> to return to Freyja]");

	while (getchar() != NL);

	TInit();
	DNewDisplay();
	}
#endif


/* ------------------------------------------------------------ */

/* Directory display. */

void
FDIRED()
	{
	char fname[FNAMEMAX];
	char buf[LINEBUFFSIZE];
#if defined(UNIX)
	char cmd_line[LINEBUFFSIZE];
	FILE *fptr;
#endif
#if defined(MSDOS)
	struct DOSFCB {
		char DOSreserved[21];
		char DOSattr;
		int DOStime;
		int DOSdate;
		long DOSsize;
		char DOSname[13];
		} fcb;
	int hr;
	int ispm;
#endif

	*fname = NUL;
	if (KGetStr("File/directory name", fname, sizeof(fname)) != 'Y') return;

#if defined(UNIX)
	if (!FMakeSys(SYS_DIRED, TRUE)) return;

	xsprintf(cmd_line, "ls %s %s", isuarg ? "-lg" : "", fname);
	if ((fptr = popen(cmd_line, "r")) == NULL) {
		DError("Cannot execute list command");
		return;
		}

	while (fgets(buf, sizeof(buf), fptr) != NULL) {
		BInsStr(buf);
		}
	pclose(fptr);
#endif
#if defined(MSDOS)
	if (!FMakeSys(SYS_DIRED, TRUE)) return;

	if (*fname == NUL) xstrcpy(fname, "*.*");
	PSystem(0x1A, &fcb);			/* set disk transfer address */

		/* look for subdirectory + system + hidden files */
	if (PSystem(0x4E, fname, 16 + 4 + 2) >= 0) {
		do	{
			BInsStr(fcb.DOSname);
			if (!isuarg) {
				BInsChar(NL);
				continue;
				}
			BInsStr("            " + min(BGetCol(), 12));
			if (fcb.DOSattr & 16) {
				BInsStr("\t<DIR>");
				}
			else	{
				xsprintf(buf, "\t%l", fcb.DOSsize);
				BInsStr(buf);
				}

			hr = (fcb.DOStime >> 11) & 0x1F;
			ispm = 0;
			if (hr > 11) {
				ispm = 1;
				hr -= 12;
				}
			if (hr == 0) hr = 12;
			xsprintf(buf, "\t%2d-%02d-%02d  %2d:%02d%c %c%c%c%c\n",
				 (fcb.DOSdate >> 5) &  0xF,
				  fcb.DOSdate       & 0x1F,
				((fcb.DOSdate >> 9) & 0x7F) + 1980,
				hr,
				(fcb.DOStime >>  5) & 0x3F,
				ispm ? 'p' : 'a',
				fcb.DOSattr & 32 ? 'a' : SP,
				fcb.DOSattr &  4 ? 's' : SP,
				fcb.DOSattr &  2 ? 'h' : SP,
				fcb.DOSattr &  1 ? 'r' : SP);
			BInsStr(buf);
			} while (PSystem(0x4F) >= 0);
		}
#endif
	BMoveToStart();
	DWindSwap();
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Find file. */

void
FFileFind()
	{
	struct buffer *bptr;

	uarg = 0;
#if defined(SYSMGR)
	if (!JGetFile("File to Find", filearg)) return;
#else
	do	{
		if (KGetStr("File to Find", filearg, sizeof(filearg)) != 'Y')
			return;
		} while (*filearg == NUL);
#endif

	bptr = BBufFind(filearg);

	if (bptr == NULL) {
		if (BBufCreate(filearg) == NULL) return;
		BFileRead();
		}
	else	BBufGoto(bptr);
	}


/* ------------------------------------------------------------ */

/* Re-read a file into the current buffer. */

void
FFileRead()
	{
	uarg = 0;
	xstrcpy(filearg, cbuf->fname);
#if defined(SYSMGR)
	if (!JGetFile("File to Read", filearg)) return;
#else
	do	{
		if (KGetStr("File to Read", filearg, sizeof(filearg)) != 'Y')
			return;
		} while (*filearg == NUL);
#endif

	if (BIsMod(cbuf) && KAsk("Throw away changes? ") != 'Y') {
		DModeLine();
		return;
		}

	xstrcpy(cbuf->fname, filearg);
	if (!BFileRead()) DError("Read error");
	}


/* ------------------------------------------------------------ */

/* Write the buffer to its file. */

void
FFileSave()
	{
	uarg = 0;
	DEcho("Writing File...");
	if (!BFileWrite()) DError("Unable to save file");
	DModeLine();
	}


/* ------------------------------------------------------------ */

/* Write the buffer to a different file. */

void
FFileWrite()
	{
	uarg = 0;
	xstrcpy(filearg, cbuf->fname);
#if defined(SYSMGR)
	if (!JGetFile("File to Write", filearg)) return;
#else
	do	{
		if (KGetStr("File to Write", filearg, sizeof(filearg)) != 'Y')
			return;
		} while (*filearg == NUL);
#endif
	xstrcpy(cbuf->fname, filearg);
	FFileSave();
	}


/* ------------------------------------------------------------ */

/* Create and set up the system buffer. Return True on success or
False on failure.  Zap the buffer if ERASE is true.  Otherwise, just
move to the end. */

FLAG
FMakeSys(name, erase)
	char *name;
	FLAG erase;
	{
	struct buffer *savebuf = cbuf;
	struct buffer *bptr;

	uarg = 0;

/* find or make it */

	if ((bptr = BBufFind(name)) != NULL)
		BBufGoto(bptr);
	else if ((bptr = BBufCreate(name)) == NULL)
		return(FALSE);

/* see if it is visible already */

	if (BMarkBuf(cwin->sstart) != cbuf) {
		DWindTwo();
		BBufGoto(savebuf);
		DIncrDisplay();
		DWindSwap();
		BBufGoto(bptr);
		DIncrDisplay();
		}

/* clean buffer */

	if (erase) {
		BMoveToStart();
		BMarkToPoint(mark);
		BMoveToEnd();
		BRegDelete(mark);
		}
	else	BMoveToEnd();
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* Open a file for input, searching the path.  NAME should not have a
directory part.  If ACTUALNAME is not NULL, the actual name as opened
will be filled in.  PExpand should be called if you want to remove all
ambuguity.  It searches the following order:

	$FREYJADIR, $HOME, $PATH, current dir
*/

#if defined(MSDOS)
#define SEPCHAR		';'
#define SEPSTR		";"
#endif
#if defined(UNIX)
#define SEPCHAR		':'
#define SEPSTR		":"
#endif

int
FPathOpen(name, actualname)
	char *name;
	char *actualname;
	{
	int fd;
	char tname[FNAMEMAX];
	char tpath[2 * FNAMEMAX];
	char *cptr;

#if defined(SYSMGR)
	JGetDir(tpath);
	tpath[strlen(tpath) - 1] = SEPCHAR;
#else
#if defined(MSDOS)
	if (c.g.special == 'J') {
		JGetDir(tpath);
		tpath[strlen(tpath) - 1] = SEPCHAR;
		}
	else	*tpath = NUL;
#else
	*tpath = NUL;
#endif
	if ((cptr = getenv("FREYJADIR")) != NULL) {
		strcat(tpath, cptr);
		strcat(tpath, SEPSTR);
		}

	if ((cptr = getenv("HOME")) != NULL) {
		strcat(tpath, cptr);
		strcat(tpath, SEPSTR);
		}

	if ((cptr = getenv("PATH")) != NULL) {
		if (*cptr == SEPCHAR)  strcat(tpath, ".");
		strcat(tpath, cptr);
		}
#endif

	for (cptr = tpath; *cptr != NUL; cptr++) {
		if (*cptr == SEPCHAR) *cptr = NUL;
		}
	*(cptr + 1) = NUL;

	for (cptr = tpath; *cptr != NUL; ) {
		xstrcpy(tname, cptr);
		F_FPathOpen_DirSep(tname);
		strcat(tname, name);
#if defined(MSDOS)
#define O_RDONLY	0	/* dummy */
#endif
		if ((fd = open(tname, O_RDONLY, 0)) >= 0) {
			if (actualname != NULL) xstrcpy(actualname, tname);
			return(fd);
			}
		while (*cptr++ != NUL) ;
		}

	if ((fd = open(name, O_RDONLY, 0)) >= 0) {
		if (actualname != NULL) xstrcpy(actualname, name);
		return(fd);
		}

	return(-1);
	}


/* ------------------------------------------------------------ */

void
F_FPathOpen_DirSep(name)
	char *name;
	{
#if defined(UNIX)
	if (*(name + strlen(name) - 1) != '/') strcat(name, "/");
#endif
#if defined(MSDOS)
	if (*(name + strlen(name) - 1) != '/' &&
		*(name + strlen(name) - 1) != '\\') strcat(name, "/");
#endif
	}


/* end of FILE.C -- File-, Buffer-, and System-Oriented Commands */
