\ Port of DICE to ForthCMP (original by Curtis Cameron).
\ *
\ This file should be included before the application.
\ The HPLXGR library must be loaded.
\ *
\ Pavel Zampach (zampach@volny.cz), 2002

DECIMAL

CREATE Dt
12 C, 12 C,
 3 C,  3 C, 21 C, 21 C,
 3 C,  3 C, 12 C, 12 C, 21 C, 21 C,
 3 C,  3 C,  3 C, 21 C, 21 C,  3 C, 21 C, 21 C,
 3 C,  3 C,  3 C, 21 C, 21 C,  3 C, 21 C, 21 C, 12 C, 12 C,
 3 C,  3 C,  3 C, 21 C, 21 C,  3 C, 21 C, 21 C,  3 C, 12 C, 21 C, 12 C,

2 2 IN/OUT
 \ [1..6, 1..6]
: Dt[a,b]
\ ( a b -- Dt[a,b] Dt[a,b+1] )
\ constructor to array Dt
  1- 2* SWAP DUP 1- * + Dt +
  DUP C@ SWAP 1+ C@
;

CREATE Dot
1 C, 0 C, 1 C, 0 C, 7 C, 0 C, 7 C, 0 C, 56 C, 124 C, 254 C, 254 C, 230 C, 124 C, 56 C,

167 CONSTANT Dicey
 30 CONSTANT wd

CREATE Dicex
107 , 168 , 228 , 291 , 350 ,
1 1 IN/OUT
: Dicex[@]
\ ( a -- n )
\ constructor to array Dicex
  1- 2* Dicex + @
;


: DrawOutlines
\ ( -- )
\ draws borders of dice
  BLACK Pen
  6 1 DO
    I Dicex[@] 1- Dicey 1- LogOrig
    1  1  wd 1+  wd 1+  0   DrawRectangle

    1       0       wd 1+  HorizLine
    wd 2 +  1       wd 1+  VertLine
    1       wd 2 +  wd 1+  HorizLine
    0       1       wd 1+  VertLine
    wd 3 +  2       wd 2 + VertLine
    2       wd 3 +  wd 2 + HorizLine
  LOOP
  0 0 LogOrig
;


 2 0 IN/OUT
: DrawDie
\ ( i n -- )
\ par i number of die (1..5)
\ par n number od dots (1..6)
  G_FORCE SetReplacementRule
  WHITE Pen
  SWAP Dicex[@] Dicey LogOrig
  2 2 wd 2 - wd 2 - 1 DrawRectangle
  BLACK Pen
  DUP 1+ 1 DO
    DUP I Dt[a,b] Dot G_FORCE PlaceArea
  LOOP
  DROP  \ n
  0 0 LogOrig
;
