'/****************************************************************************/
'/* CELLEDIT.BAS  Edit a single text cell on a screen                        */
'/*               by Dale Thorn                                              */
'/*               Rev. 27.06.2002                                            */
'/*                                                                          */
'/*  IN: ctyp - Field data type and edit/display characteristics             */
'/*      cdat - Data to be edited (padded to full length of cell)            */
'/*      irow - Physical screen row where cell is located                    */
'/*      icol - Physical screen column where cell begins                     */
'/*      iclr - Foreground/background color of cell                          */
'/*      iofs - Current cursor offset within cell                            */
'/*      icsr - Insert/overstrike cursor type                                */
'/****************************************************************************/

function iedt.cell(ctyp, cdat, irow, icol, iclr, iofs, icsr)

   iclc = bitget(ctyp, EDIT.CLC)
   idat = bitget(ctyp, EDIT.DAT + 0) or _
          bitget(ctyp, EDIT.DAT + 1)
   itim = bitget(ctyp, EDIT.TIM)
   cwrd = cedt.cellfill(ctyp, cdat)
   i = io.vdsp(cdat, irow, icol, iclr)
   ilen = len(cdat)
   if iofs >= ilen then
      iofs = ilen - 1
   elseif iofs < 0 then
      iofs = 0
   end if
   do while iofs >= 0 and iofs < ilen
      if icsr = ICSR.CINS then
         cins = "I"
      else
         cins = "O"
      end if
      i = io.vdsp(cins, irow + 2, icol, iclr)
      i = io.vcsr(irow, icol + iofs, 1)
      ikey = io.kget(0)
      select case ikey
         case KEY.BKSPC, _
              KEY.DEL
            if ikey = KEY.BKSPC then
               if idat or itim then
                  if iofs = 1 or iofs = 4 or iofs = 7 then
                     iofs = iofs - 1
                     ikey = KEY.DEL
                  end if
               elseif iofs > 0 then
                  iofs = iofs - 1
                  ikey = KEY.DEL
               end if
            end if
            if ikey = KEY.DEL then
               if idat or itim then
                  mid$(cdat, iofs + 1) = mid$(cdat, iofs + 2, 1) + char(32)
                  i = io.vdsp(mid$(cdat, iofs + 1, 2), irow, icol + iofs, iclr)
               else
                  mid$(cdat, iofs + 1) = mid$(cdat, iofs + 2) + char(32)
                  i = io.vdsp(mid$(cdat, iofs + 1), irow, icol + iofs, iclr)
               end if
            end if
         case KEY.CSRLT
            iofs = iofs - 1
            if idat or itim then
               if iofs = 2 or iofs = 5 then
                  iofs = iofs - 1
               end if
            end if
         case KEY.CSRRT
            iofs = iofs + 1
            if idat or itim then
               if iofs = 2 or iofs = 5 then
                  iofs = iofs + 1
               end if
            end if
         case KEY.END
            if idat or itim then
               iofs = ilen - 1
            else
               iofs = len(rtrim$(cdat))
               if iofs = ilen then
                  iofs = ilen - 1
               end if
            end if
         case KEY.HOME
            if idat or itim then
               iofs = 0
            else
               iofs = ilen - len(ltrim$(cdat))
               if iofs = ilen then
                  iofs = 0
               end if
            end if
         case KEY.INS
            if icsr = ICSR.CINS then
               icsr = ICSR.COVR
            else
               icsr = ICSR.CINS
            end if
         case else
            if instr(cwrd, char(ikey)) then
               ierr = 0
               if bitget(ctyp, EDIT.NUM) and bitget(ctyp, EDIT.CHR) = 0 then
                  itmp = ilen - len(ltrim$(cdat))
                  iadj = abs(icsr <> ICSR.CINS)
                  if ikey = 45 then
                     if instr(cdat, char(45)) > 0 _
                     or iofs < itmp - iadj _
                     or iofs > itmp then
                        ierr = not 0
                        beep
                     end if
                  elseif ikey = 46 then
                     if instr(cdat, char(46)) > 0 _
                     or iofs > len(rtrim$(cdat)) _
                     or iofs < itmp - iadj then
                        ierr = not 0
                        beep
                     end if
                  end if
               end if
            elseif ikey >= 32 and ikey <= 127 then
               ierr = not 0
               beep
            else
               exit do
            end if
            if not ierr then
               if ikey >= 97 and ikey <= 122 then
                  if bitget(ctyp, EDIT.UPC) then
                     ikey = ikey - 32
                  end if
               elseif ikey >= 65 and ikey <= 90 then
                  if bitget(ctyp, EDIT.LWC) then
                     ikey = ikey + 32
                  end if
               end if
               if icsr = ICSR.CINS then
                  if idat or itim then
                     itmp = 1 - iofs mod 3
                     mid$(cdat, iofs + 1) = char(ikey) + mid$(cdat, iofs + 1, itmp)
                     i = io.vdsp(mid$(cdat, iofs + 1, itmp + 1), irow, icol + iofs, iclr)
                  else
                     mid$(cdat, iofs + 1) = char(ikey) + mid$(cdat, iofs + 1)
                     i = io.vdsp(mid$(cdat, iofs + 1), irow, icol + iofs, iclr)
                  end if
               else
                  if iofs = 0 and iclc then
                     lset cdat = char(ikey)
                     i = io.vdsp(cdat, irow, icol, iclr)
                  else
                     mid$(cdat, iofs + 1) = char(ikey)
                     i = io.vdsp(char(ikey), irow, icol + iofs, iclr)
                  end if
               end if
               iofs = iofs + 1
               if idat or itim then
                  if iofs = 2 or iofs = 5 then
                     iofs = iofs + 1
                  end if
               end if
            end if
      end select
   loop
   i = io.vcsr(24, 79, 0)
   iedt.cell = ikey
end function

function cedt.cellfill(ctyp, cdat) static

   'Bit positions:
   '---------------------------------------------------------------------------
   'EDIT.CHR = 0                                       '/*  0 = Alpha    OK  */
   'EDIT.NUM = 1                                       '/*  1 = Numeric  OK  */
   'EDIT.NEG = 2                                       '/*  2 = Negative OK  */
   'EDIT.DEC = 3 to 5                                  '/*  3-5 = #Decimals  */
   'EDIT.JUL = 6                                       '/*  6 = Just.left    */
   'EDIT.JUC = 7                                       '/*  7 = Just.center  */
   'EDIT.JUR = 8                                       '/*  8 = Just.right   */
   'EDIT.UPC = 9                                       '/*  9 = Uppercase    */
   'EDIT.LWC = 10                                      '/* 10 = Lowercase    */
   'EDIT.ZFL = 11                                      '/* 11 = Zero fill    */
   'EDIT.CLC = 12                                      '/* 12 = pos.#1 clear */
   'EDIT.DAT = 13 to 14                                '/* 13-14 Date seps:  */
   '                                                   '/*   1 = '/'         */
   '                                                   '/*   2 = '-'         */
   '                                                   '/*   3 = '.'         */
   'EDIT.TIM = 15                                      '/* 15 = Time field   */

   if bitget(ctyp, EDIT.CHR) then
      if bitget(ctyp, EDIT.NUM) then
         cwrd = space$(224)
         for i = 1 to 224
            mid$(cwrd, i) = char(i + 31)
         next
      else
         cwrd = space$(53)
         for i = 1 to 26
            mid$(cwrd, i) = char(i + 64)
         next
         for i = 27 to 52
            mid$(cwrd, i) = char(i + 70)
         next
         mid$(cwrd, 53) = char(32)
      end if
   else
      idat = bitget(ctyp, EDIT.DAT + 0) * 1 + _
             bitget(ctyp, EDIT.DAT + 1) * 2 + _
             bitget(ctyp, EDIT.TIM) * EDIT.TIM
      if idat then
         cwrd = space$(10)
         for i = 1 to 10
            mid$(cwrd, i) = char(i + 47)
         next
         if idat = EDIT.TIM then
            isep = 58   ':'
         elseif idat = 3 then
            isep = 46   '.'
         elseif idat = 2 then
            isep = 45   '-'
         else
            isep = 47   '/'
         end if
         mid$(cdat, 3) = char(isep)
         mid$(cdat, 6) = char(isep)
      else
         idec = bitget(ctyp, EDIT.DEC + 0) * 1 + _
                bitget(ctyp, EDIT.DEC + 1) * 2 + _
                bitget(ctyp, EDIT.DEC + 2) * 4
         ineg = bitget(ctyp, EDIT.NEG)
         cwrd = space$(10 + idec + ineg)
         for i = 1 to 10
            mid$(cwrd, i) = char(i + 47)
         next
         if idec then
            mid$(cwrd, 11) = char(46)
         end if
         if ineg then
            mid$(cwrd, 11 + idec) = char(45)
         end if
      end if
   end if
   cedt.cellfill = cwrd
end function
