'/* INDENT.BAS Indent BASIC program code in ASCII text file */
'/*            By: Dale Thorn                               */
'/*            Rev. 10.07.2003                              */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'

declare function io.kget(inop)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

dim clinbuf(24)                              'initialize code line parser array
imaxcmdlen = 24                               'set maximum BASIC command length

ccmd = ucase$(rtrim$(command$))             'get user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  INDENT  [indentsize (default=4)]", 5, 24, 79, 0, 1)
end if                                  'display usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse the command-line params
if iprm > 0 then                          'maximum no. of parameters is one (1)
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)  'invalid filename message
end if                                  'display error message [above] and exit

if iprm = 0 then                                  'user supplied an indent size
   indentsiz = pdqvali(cprm(0))                    'get user's text-indent size
   if indentsiz < 3 or indentsiz > 8 then           'text-indent size NOT valid
      i = ifn.msgs("Invalid indent size (3 to 8)", 5, 24, 79, 1, 1)
   end if                               'display error message [above] and exit
else                                        'user did NOT supply an indent size
   indentsiz = 4                                   'set the default indent size
end if

i = ifn.open(1, cfil, "S", llof)           'open source file in sequential mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1) 'display error msg. & exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)'display error msg. & exit
end if                                  'display error message [above] and exit

i = ifn.msgs("Processing " + cfil + " - Please standby", 5, 24, 79, 0, 0)

select case cext                         'select on current user file extension
   case "bas"                              'current user file extension = "BAS"
      cdst = cnam + ".ba1"                  'set output file extension to "BA1"
   case "cls"                              'current user file extension = "CLS"
      cdst = cnam + ".cl1"                  'set output file extension to "CL1"
   case "frm"                              'current user file extension = "FRM"
      cdst = cnam + ".fr1"                  'set output file extension to "FR1"
   case "glb"                              'current user file extension = "GLB"
      cdst = cnam + ".gl1"                  'set output file extension to "GL1"
   case "out"                              'current user file extension = "OUT"
      cdst = cnam + ".tmp"                  'set output file extension to "TMP"
   case "sub"                              'current user file extension = "SUB"
      cdst = cnam + ".su1"                  'set output file extension to "SU1"
   case else                              'current user file extension <> "OUT"
      if left$(cext, 2) = "dh" then         'current user file extension = "DH"
         cdst = cnam + ".d1" + mid$(cext, 3)'set output file extension to "D1?"
      else                                 'current user file extension <> "DH"
         cdst = cnam + ".out"               'set output file extension to "OUT"
      end if
end select
open cdst for output as 2                 'open destination file in output mode

for i = 1 to imaxcmdlen                   'loop thru the code line parser array
   clinbuf(i) = space$(i)                 'set each element to its no.of spaces
next
clinbuffer = space$(600)                     'initialize the master line buffer
ibeginact = 0                                 'initialize the begin-active flag
icasfound = 0                                   'initialize the case-found flag
icasstruc = 0                               'initialize the case-structure flag
icurrcont = 0                                'initialize line-continuation flag
indentlvl = 0                                 'initialize the text-indent level
iblanklin = not 0                              'pre-set blank-line flag to TRUE

csav = ""                                     'initialize saved portion of line
while not eof(1)                              'loop thru user's sourcecode file
   if csav = "" then                           'saved portion of prev. line n/a
      line input #1, clin                     'read a line from the source file
   else                                      'saved portion of prev.line exists
      swap clin, csav                        'set current line to saved portion
      csav = ""                               'initialize saved portion of line
   end if
   i = ifn.rtab(clin, 1)                      'remove any "hard" tabs from line
   clin = ltrim$(rtrim$(clin))               'left-justify the source code line
   if not icurrcont then                       'current line NOT a continuation
      ipos1 = istr.lnsp(1, clin)              'position following BASIC line no.
      if ipos1 > 1 then                        'BASIC line no. found in source!
         clin = ltrim$(mid$(clin, ipos1))         'remove the BASIC line number
      end if
   end if
   lset clinbuffer = ucase$(clin)            'uppercase text line in the buffer
   i = istr.rcmt(clinbuffer)                   'remove BASIC comments from line
   ctmpbuffer = rtrim$(clinbuffer)            'make RTrim'd copy of line buffer
   if right$(ctmpbuffer, 1) = "_" then        'this line continues to next line
      icurrcont = not 0                         'set the line-continuation flag
   else                                         'line does NOT continue to next
      icurrcont = 0                           'clear the line-continuation flag
   end if
   ipos1 = instr(ctmpbuffer, ":")          'line label or multi-statement line?
   ipos2 = instr(ctmpbuffer, " ")          'first blank space occurring in line
   ipos3 = instr(ctmpbuffer, " THEN ")     ' position of "then" in current line
   ilen1 = len(ctmpbuffer)                 'length of line's code less comments
   if ipos1 = 1 then                          'redundant ':' in BASIC code line
      clin = ltrim$(mid$(clin, 2))              'remove redundant ':' from line
      lset clinbuffer = ltrim$(mid$(clinbuffer, 2))'remove redundant ':' f/line
      ctmpbuffer = rtrim$(clinbuffer)          'get RTrim'd copy of line buffer
   elseif ipos1 > 0 and ipos1 = ilen1 then    ':' was found at end of code line
      if ipos2 then                           'NOT a label, so ':' is redundant
         mid$(clinbuffer, ilen1) = " "         '...so just remove redundant ':'
         ctmpbuffer = rtrim$(clinbuffer)       'get RTrim'd copy of line buffer
      end if
   elseif ipos1 then                        'line-label or multi-statement line
      iquo2 = 0                               'initialize second quote position
      do                                        'loop to test for quoted string
         iquo1 = instr(iquo2 + 1, ctmpbuffer, char(34)) 'get 1st quote position
         iquo2 = instr(iquo1 + 1, ctmpbuffer, char(34)) 'get 2nd quote position
         if iquo1 < ipos1 and iquo2 > ipos1 then        ':' is in quoted string
            exit do                            'quoted string, so don't process
         elseif iquo2 = 0 or iquo1 > ipos1 then    'quotes n/a, so process line
            if ipos2 > 0 and ipos2 < ipos1 then    'this is a multi-stmt. line!
               if ipos3 = 0 or ipos3 > ipos1 then   'then-clause not applicable
                  csav = ltrim$(mid$(clin, ipos1 + 1)) 'save part following ':'
                  clin = rtrim$(left$(clin, ipos1 - 1))  'set line to 1st stmt.
               end if
            else                                'this is a label+statement line
               print #2, rtrim$(left$(clin, ipos1))  'output label part of line
               clin = ltrim$(mid$(clin, ipos1 + 1)) 'set line to remaining text
               lset clinbuffer = ltrim$(mid$(clinbuffer, ipos1 + 1))
               ctmpbuffer = rtrim$(clinbuffer) 'get RTrim'd copy of line buffer
            end if
            exit do                            'process complete; exit the loop
         end if
      loop
   end if

   lset clinbuf(imaxcmdlen) = clinbuffer      'text line -> last parser element
   for i = imaxcmdlen to 2 step -1            'loop thru code line parser array
      lset clinbuf(i - 1) = clinbuf(i)        'text line -> curr.parser element
   next

   for i = imaxcmdlen to 4 step -1            'loop thru code line parser array
      select case clinbuf(i)                  'select on potential BASIC syntax
         case "PRIVATE STATIC PROPERTY ", _  'current line begins PROPERTY proc.
              "PRIVATE STATIC FUNCTION ", _  'current line begins FUNCTION proc.
              "PUBLIC STATIC PROPERTY ", _   'current line begins PROPERTY proc.
              "PUBLIC STATIC FUNCTION ", _   'current line begins FUNCTION proc.
              "PRIVATE STATIC SUB ", _       'current line begins SUB procedure
              "PUBLIC STATIC SUB ", _        'current line begins SUB procedure
              "PRIVATE PROPERTY ", _         'current line begins PROPERTY proc.
              "PRIVATE FUNCTION ", _         'current line begins FUNCTION proc.
              "PUBLIC PROPERTY ", _          'current line begins PROPERTY proc.
              "PUBLIC FUNCTION ", _          'current line begins FUNCTION proc.
              "STATIC PROPERTY ", _          'current line begins PROPERTY proc.
              "STATIC FUNCTION ", _          'current line begins FUNCTION proc.
              "PRIVATE TYPE ", _             'current line begins TYPE declarat.
              "PRIVATE ENUM ", _             'current line begins ENUM declarat.
              "PUBLIC TYPE ", _              'current line begins TYPE declarat.
              "PUBLIC ENUM ", _              'current line begins ENUM declarat.
              "PRIVATE SUB ", _              'current line begins SUB procedure
              "STATIC SUB ", _               'current line begins SUB procedure
              "PUBLIC SUB ", _               'current line begins SUB procedure
              "PROPERTY ", _                 'current line begins PROPERTY proc.
              "FUNCTION ", _                 'current line begins FUNCTION proc.
              "FRIEND ", _                   'current line begins ??? procedure
              "ENUM ", _                     'current line begins ENUM declarat.
              "SUB "                         'current line begins SUB procedure
            indentlvl = 0                     'set current indent level to zero
            exit for                         'code line matches case; exit loop
         case "ENDPROPERTY ", _                'current line ends BEGINPROPERTY
              "ELSEIF ", _                    'current line begins ELSEIF block
              "WEND ", _                     'current line ends WHILE/WEND-loop
              "THEN ", _                       'current line continues IF-block
              "NEXT ", _                       'current line ends FOR/NEXT-loop
              "LOOP ", _                        'current line ends DO/LOOP-loop
              "ELSE "                           'current line begins ELSE block
            indentlvl = indentlvl - 1       'decrement the current indent level
            exit for                         'code line matches case; exit loop
         case "END SELECT "                 'current code line ends SELECT CASE
            if icasfound = icasstruc then  'CASE statement found in curr.SELECT
               icasfound = icasfound - 1     'decrement the case-found variable
               indentlvl = indentlvl - 1    'decrement the current indent level
            end if
            icasstruc = icasstruc - 1        'decrement case-structure variable
            indentlvl = indentlvl - 1       'decrement the current indent level
            exit for                         'code line matches case; exit loop
         case "DEF FN"                       'current code line begins DEF FNxx
            if instr(ctmpbuffer, "=") = 0 then  'not a single-line DEF function
               indentlvl = 0              'set the current indent level to zero
            end if
            exit for                         'code line matches case; exit loop
         case "TYPE "                       'current code line begins TYPE decl.
            ipos1 = istr.lcsp(5, clinbuffer, " ")   'character following "TYPE"
            if mid$(clinbuffer, ipos1, 3) <> "AS " _     'not a "Type" property
            and mid$(clinbuffer, ipos1, 1) <> "=" then   'not a "Type" property
               indentlvl = 0              'set the current indent level to zero
            end if
            exit for                         'code line matches case; exit loop
         case "CASE "                       'current code line begins CASE stmt.
            if icasfound = icasstruc then  'CASE statement found in curr.SELECT
               indentlvl = indentlvl - 1    'decrement the current indent level
            end if        'set case-found value to case-structure value [below]
            icasfound = icasstruc
            exit for                         'code line matches case; exit loop
         case "END "                          'current code line ends ???-block
            if ctmpbuffer = "END" then          'possible program-end statement
               if ibeginact > 0 then          'end of BEGIN block in FRM header
                  ibeginact = ibeginact - 1    'decrement current "begin" level
                  indentlvl = indentlvl - 1     'decrement current indent level
               end if
            else                                'possible program-end statement
               ichr = midchar(ctmpbuffer, istr.lcsp(4, ctmpbuffer, " "))
               if ichr >= 65 then              'end of code-structure statement
                  indentlvl = indentlvl - 1     'decrement current indent level
               end if
            end if
            exit for                         'code line matches case; exit loop
         case else                               'not valid for this loop index
            if right$(ctmpbuffer, 1) = ":" then'probable BASIC Gosub/Goto label
               isavlevel = indentlvl       'save the current indent level value
               indentlvl = 0              'set the current indent level to zero
               exit for                      'code line matches case; exit loop
            end if
      end select
   next

   if indentlvl < 0 then              'this code not allowing for new syntax(?)
      i = ifn.msgs("Invalid structure in " + cfil + " - indent level < zero", _
                   5, 24, 79, 1, 0)  'display error message [above] do NOT exit
      locate 7, 5, 1                       'locate cursor for next-line display
      print "Press any key to return to operating system"'message for user exit
      i = io.kget(0)                                'wait for user to press key
      close                           'close all files in case not closed above
      system                            'return control to the operating system
   end if                               'display error message [above] and exit

   if clin <> "" then                               'current line contains text
      print #2, space$(indentlvl * indentsiz); clin 'left-hand margin plus line
      iblanklin = 0                                 'set blank-line flag to OFF
   elseif not(iblanklin or eof(1)) then             'OK to print the blank line
      print #2, clin                               'print the current line text
      iblanklin = not 0                              'set blank-line flag to ON
   end if

   for i = imaxcmdlen to 3 step -1            'loop thru code line parser array
      select case clinbuf(i)                  'select on potential BASIC syntax
         case "PRIVATE STATIC PROPERTY ", _  'current line begins PROPERTY proc.
              "PRIVATE STATIC FUNCTION ", _  'current line begins FUNCTION proc.
              "PUBLIC STATIC PROPERTY ", _   'current line begins PROPERTY proc.
              "PUBLIC STATIC FUNCTION ", _   'current line begins FUNCTION proc.
              "PRIVATE STATIC SUB ", _       'current line begins SUB procedure
              "PUBLIC STATIC SUB ", _        'current line begins SUB procedure
              "PRIVATE PROPERTY ", _         'current line begins PROPERTY proc.
              "PRIVATE FUNCTION ", _         'current line begins FUNCTION proc.
              "STATIC PROPERTY ", _          'current line begins PROPERTY proc.
              "STATIC FUNCTION ", _          'current line begins FUNCTION proc.
              "PUBLIC PROPERTY ", _          'current line begins PROPERTY proc.
              "PUBLIC FUNCTION ", _          'current line begins FUNCTION proc.
              "BEGINPROPERTY ", _            'current line begins BEGINPROPERTY
              "PRIVATE TYPE ", _             'current line begins TYPE declarat.
              "PRIVATE ENUM ", _             'current line begins ENUM declarat.
              "PUBLIC TYPE ", _              'current line begins TYPE declarat.
              "PUBLIC ENUM ", _              'current line begins ENUM declarat.
              "PRIVATE SUB ", _              'current line begins SUB procedure
              "STATIC SUB ", _               'current line begins SUB procedure
              "PUBLIC SUB ", _               'current line begins SUB procedure
              "PROPERTY ", _                 'current line begins PROPERTY proc.
              "FUNCTION ", _                 'current line begins FUNCTION proc.
              "FRIEND ", _                   'current line begins ??? procedure
              "ELSEIF ", _                    'current line begins ELSEIF block
              "WHILE ", _                       'current line begins WHILE-loop
              "WITH ", _                        'current line begins WITH block
              "THEN ", _                       'current line continues IF-block
              "ENUM ", _                     'current line begins ENUM declarat.
              "ELSE ", _                        'current line begins ELSE block
              "CASE ", _                    'current line begins CASE statement
              "SUB ", _                      'current line begins SUB procedure
              "FOR ", _                      'current line begins FOR/NEXT-loop
              "DO "                           'current line begins DO/LOOP-loop
            indentlvl = indentlvl + 1       'increment the current indent level
            exit for                         'code line matches case; exit loop
         case "SELECT CASE "              'current code line begins SELECT CASE
            icasstruc = icasstruc + 1        'increment case-structure variable
            indentlvl = indentlvl + 1       'increment the current indent level
            exit for                         'code line matches case; exit loop
         case "DEF FN"                       'current code line begins DEF FNxx
            if instr(ctmpbuffer, "=") = 0 then  'not a single-line DEF function
               indentlvl = indentlvl + 1    'increment the current indent level
            end if
            exit for                         'code line matches case; exit loop
         case "BEGIN "                    'current code line begins BEGIN block
            ibeginact = ibeginact + 1       'increment the current indent level
            indentlvl = indentlvl + 1       'increment the current indent level
            exit for                         'code line matches case; exit loop
         case "TYPE "                       'current code line begins TYPE decl.
            if mid$(clinbuffer, ipos1, 3) <> "AS " _     'not a "Type" property
            and mid$(clinbuffer, ipos1, 1) <> "=" then   'not a "Type" property
               indentlvl = indentlvl + 1    'increment the current indent level
            end if
            exit for                         'code line matches case; exit loop
         case "IF "                          'current code line begins IF-block
            if right$(ctmpbuffer, 5) = " THEN" or icurrcont then  'block = TRUE
               indentlvl = indentlvl + 1    'increment the current indent level
            end if
            exit for                         'code line matches case; exit loop
         case else                               'not valid for this loop index
            if right$(ctmpbuffer, 1) = ":" then'probable BASIC Gosub/Goto label
               indentlvl = isavlevel        'restore current indent level value
               exit for                      'code line matches case; exit loop
            end if
      end select
   next
wend

i = ifn.msgs("Output file: " + cdst, 5, 24, 79, 0, 1) 'display message and exit
close                                 'close all files in case not closed above
system                                  'return control to the operating system

function io.kget(inop)                 ' get key value (don't strip key buffer)
   do                                          ' begin loop to strip key buffer
   loop while inkey$ <> ""               ' loop while key buffer contains a key
   do                                         ' loop to get key from key buffer
      ckey = inkey$                                   ' get key from key buffer
   loop while ckey = ""                               ' loop until a key is hit
   if asc(ckey) then                                  ' key value in first byte
      io.kget = asc(ckey)                 ' return key value to calling program
   else                                           ' zero value ("extended" key)
      io.kget = asc(mid$(ckey, 2)) + 128           ' add 128 to 2nd byte of key
   end if
end function
