#ifndef PLATFORM_H
#define PLATFORM_H

#include "factor.h"

#define FLOORHEIGHT 40

#define FLOOR 0x01 //floor bit.

class platformBeast : public factor
{
public:
  int xMomentum, yMomentum, gravity, moveIncrement, jumpIncrement;
  int hitPoints, alignment, damage;
  platformBeast() {xMomentum = alignment = damage = yMomentum = hitPoints= moveIncrement = jumpIncrement = 0;
                   gravity = 2;};
  virtual void advance(void);
  void die(void);
  enum command {goLeft, goRight, jump};
  int targetTerrain() {return mymap->mapData[(mapX*mymap->squareWidth + squareX + xMomentum) / (mymap->squareWidth)]
                                             [(mapY*mymap->squareWidth + squareY + yMomentum) / (mymap->squareWidth)].myTerrainType;};
  void go(command myCommand);
};

class player;

class missile : public platformBeast
{
public:
  int range;
  int missileNumber;
  int damage;
  player * owningPlayer;
  missile(void) {gravity = 0; range = missileNumber = damage = 0; owningPlayer = NULL;}
  virtual void advance(void);
};

class player : public platformBeast
{
public:
  missile * myMissiles[5];
  int numMissiles; //number of missiles he can fire
  int missileType;
  player(void) : platformBeast() {myMissiles[0] = myMissiles[1] = myMissiles[2] = myMissiles[3]=
                                  myMissiles[4] = NULL;};
  void fireMissile(void);
  virtual missile * missileGenerator(int missileType) {return NULL;};
  int hitWithMissile(platformBeast * target);
};

class crawler : public platformBeast
{
public:
  virtual void advance(void);
};

#endif