#ifndef GADGETS.H

#define GADGETS.H

#include "animicon.h"
#include "yakmouse.h"
#include "xlib.h"

#define HELP_MASK 4096

class gadget : public animicon
{
public:
  enum flagType {normal = 0, touchPad = 1};
  enum gadgetType {buttonType = 1, pSwitchType = 2, sliderType = 3};
  virtual byte isSelected(void);
  word x, y;
  word relX, relY; //used by gadgetManager
  char commandChar;
  flagType flags;
  gadgetType type;
  gadget(char commandChar, char * filename, icon::flagType aflags = icon::normal, yakLib * myYakLib = NULL, gadget::flagType iflags = gadget::normal, int ix = 0, int iy = 0);
  gadget(char icommandChar, animiconNode * thisFrame, gadget::flagType iflags = gadget::normal, int ix = 0, int iy=0);
  gadget(void) : animicon() {x = y = 0; commandChar = 0; flags = normal;};
  virtual void draw(int ix, int iy, word offset) {x=ix; y=iy; animicon::draw(x, y, offset);};
  virtual void draw(word offset = VisiblePageOffs) {draw(x, y, offset);};
  virtual int activate(void) = 0;
  virtual int status(void) = 0;
};

class button : public gadget
{
public:
  int returnValue;
  button(int ix, int iy, char commandChar, int returnValue, char * filename, icon::flagType flags = icon::normal, yakLib * myYakLib = NULL, gadget::flagType iflags = gadget::normal);
  virtual int activate(void);
  virtual int status(void);
};

class label : public button
{
public:
  char * myText;
  byte fgColor, bgColor;
  label(int ix, int iy, char commandChar, int returnValue, char * text, byte ifgColor = 15, byte ibgColor = 0, gadget::flagType iflags = gadget::normal);
  virtual void draw(int ix, int iy, word offset);
  virtual byte isSelected(void);
};

class pSwitch : public gadget
{
public:
  int position;
  pSwitch(int ix, int iy, char commandChar, char * filename, icon::flagType flags = icon::normal, yakLib * myYakLib = NULL, gadget::flagType iflags = gadget::normal);
  virtual int activate(void);
  virtual int status(void);
};

class slider : public gadget
{
public:
  int position, width, height;
  int minimumValue, maximumValue;
  byte barColor, borderColor, indicatorColor;
  slider(int ix, int iy, int iwidth, int iheight, int minimumValue, int maximumValue, byte barColor = 0, byte borderColor = 10, byte indicatorColor = 25);
  slider() : gadget() {position = width = height = minimumValue = maximumValue = 0; position = width = height = 0;};
  virtual void draw(word offset = VisiblePageOffs);
  virtual void draw(int x, int y, word offset);
  virtual int activate(void);
  virtual int status(void);
};

//Node definitions Follow------------------------------------------>

class gadgetNode
{
public:
  gadgetNode * nextGadget;
  gadgetNode * prevGadget;
  gadget * thisGadget;
  gadgetNode(gadget * newGadget, gadgetNode * newNextGadget) {nextGadget = newNextGadget; thisGadget = newGadget, prevGadget = NULL;};
};

//list definitions follow----------------------------------------->

class gadgetList
{
public:
  gadgetNode * firstGadget;
  gadgetNode * lastGadget;
  virtual int status(void);
  gadgetList() {firstGadget = lastGadget = NULL;};
  void draw(int x, int y, word offset = VisiblePageOffs);
  void draw(word offset = VisiblePageOffs);
  void add(gadgetNode * theNewGadget);
};
#endif
