#ifndef YAKSOUND.H

#define YAKSOUND.H

#include <dos.h>
#include "yaklib.h"

class yakSample
{
public:
  byte * sampleData;
  unsigned long sampleLength;
  void play(word sampleRate = 11000, word stereo = 1, word voice = 1, unsigned long length = 0);
  yakSample(void) {sampleData = NULL;};
  yakSample(char * filename) {sampleData = NULL; load(filename);};
  byte * load(char * filename);
};

class yakVoc
{
public:
  byte * sampleData;
  void load(char * filename, yakLib * myYakLib = NULL);
  void play(void);
};

void CTLoad(void);
int CTGetVersion(void);
void CTSetIOAddr(int base);
void CTSetIRQ(int irq);
int CTInitialize(void);
void CTUninstall(void);
void CTSpeakerOn(void);
void CTSpeakerOff(void);
void CTSetStatusWord(word * address);
void CTOutputVoice(char * buffer);
void CTInputVoice(int sampleRate, char* buffer, long length);
void CTStopVoiceProcess(void);
int CTPauseOutputVoice(void);
int CTContinueOutputVoice(void);


#endif
