/*
 *  vectors.c      vector table for the 68hc12
 */

#include  "isr.h"

extern void  ISR_Empty(void);
extern void  ISR_RTI(void);
extern void  _start(void);


 
/*
 *  This is not a routine but a table that the linker can use to assign
 *  vectors to the various interrupt service routines (ISRs).  This
 *  table must ultimately appear in the 68hc12's vector area starting
 *  at 0xff80.
 */



void  ( * const vector[])()  =  {
    ISR_Empty,                      // $ff80
    ISR_Empty,                      // $ff82
    ISR_Empty,                      // $ff84
    ISR_Empty,                      // $ff86
    ISR_Empty,                      // $ff88
    ISR_Empty,                      // $ff8a
    ISR_Empty,                      // $ff8c
    ISR_Empty,                      // $ff8e
    ISR_Empty,                      // $ff90
    ISR_Empty,                      // $ff92
    ISR_Empty,                      // $ff94
    ISR_Empty,                      // $ff96
    ISR_Empty,                      // $ff98
    ISR_Empty,                      // $ff9a
    ISR_Empty,                      // $ff9c
    ISR_Empty,                      // $ff9e
    ISR_Empty,                      // $ffa0
    ISR_Empty,                      // $ffa2
    ISR_Empty,                      // $ffa4
    ISR_Empty,                      // $ffa6
    ISR_Empty,                      // $ffa8
    ISR_Empty,                      // $ffaa
    ISR_Empty,                      // $ffac
    ISR_Empty,                      // $ffae
    ISR_Empty,                      // $ffb0
    ISR_Empty,                      // $ffb2
    ISR_Empty,                      // $ffb4
    ISR_Empty,                      // $ffb6
    ISR_Empty,                      // $ffb8
    ISR_Empty,                      // $ffba
    ISR_Empty,                      // $ffbc
    ISR_Empty,                      // $ffbe
    ISR_Empty,                      // $ffc0
    ISR_Empty,                      // $ffc2
    ISR_Empty,                      // $ffc4
    ISR_Empty,                      // $ffc6
    ISR_Empty,                      // $ffc8
    ISR_Empty,                      // $ffca
    ISR_Empty,                      // $ffcc
    ISR_Empty,                      // $ffce
    ISR_Empty,                      // $ffd0
    ISR_Empty,                      // $ffd2
    ISR_Empty,                      // $ffd4
    ISR_Empty,                      // $ffd6
    ISR_Empty,                      // $ffd8
    ISR_Empty,                      // $ffda
    ISR_Empty,                      // $ffdc
    ISR_Empty,                      // $ffde
    ISR_Empty,                      // $ffe0
    ISR_Empty,                      // $ffe2
    ISR_Empty,                      // $ffe4
    ISR_Empty,                      // $ffe6
    ISR_Empty,                      // $ffe8
    ISR_Empty,                      // $ffea
    ISR_Empty,                      // $ffec
    ISR_Empty,                      // $ffee
    ISR_Empty,                      // $fff0  RTI vector goes here if needed
//    ISR_RTI,                        // $fff0  RTI    // only needed for RTI support
    ISR_Empty,                      // $fff2
    ISR_Empty,                      // $fff4
    ISR_Empty,                      // $fff6
    ISR_Empty,                      // $fff8
    ISR_Empty,                      // $fffa
    ISR_Empty,                      // $fffc
    _start                          // $fffe
};


	




