		.386
		.model flat

seg000		segment	byte public 'CODE' use32
		assume cs:seg000
		assume es:nothing, ss:nothing, ds:nothing, fs:nothing, gs:nothing
		
		org 27Eh


		call check_reset
		call send_data

loc_29B:				; CODE XREF: sub_24C+16j sub_24C+2Cj
		pop	edi
		pop	es
		pop	ds
		assume ds:nothing
		mov	eax, 0
		leave
		retf


; #################################################
; #################################################
; #################################################


send_data:
loc_27E:				; CODE XREF: sub_24C+4Dj
		inc	dx
		push	ecx
		mov	ecx, 0FFFFh

loc_286:				; CODE XREF: sub_24C+43j
		in	al, dx
		and	al, 40h
		jz	loc_291
		loop	loc_286


loc_291:				; CODE XREF: sub_24C+3Dj
		pop	ecx
		dec	dx
		mov	al, es:[edi]
		inc	edi
		out	dx, al

		; cx != 0
		loop	loc_27E
		ret


; #################################################
; #################################################
; #################################################

check_reset:
		push eax
		push ecx
		push edi
		push es
		push fs

		push es
		pop fs

		push cs
		pop es



		; 1st time init
		mov al,es:gs_init
		cmp al,0
		je send_reset



		; look for special reset code 7B
		mov al,es:gs_flag
		cmp al,1
		je check_flag_off


		mov al,fs:[edi]
		cmp al,0B0h
		jb reset_done

		cmp al,0C0h
		jge reset_done

		mov al,fs:[edi+1]
		cmp al,7Bh
		je send_reset

		jmp reset_done



check_flag_off:
		mov al,fs:[edi]
		cmp al,0C0h
		jb reset_done

		cmp al,0D0h
		jge reset_done


		; check reset condition again
		mov es:gs_flag,0
		jmp reset_done



send_reset:
		lea edi,gs_reset
		mov ecx,11
		call send_data


		mov es:gs_init,1
		mov es:gs_flag,1



reset_done:
		pop fs
		pop es
		pop edi
		pop ecx
		pop eax
		ret



gs_init   db 00
gs_flag	  db 00

gs_reset  db 0F0h
db 41h
db 10h
db 42h
db 12h
db 40h
db 00h
db 7Fh
db 00h
db 41h
db 0F7h



seg000		ends


		end
