<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_ext_filter - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_ext_filter</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_ext_filter.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_ext_filter.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_ext_filter.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_ext_filter.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Fait traiter le corps de la rponse par un programme
externe avant de l'envoyer au client</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>ext_filter_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_ext_filter.c</td></tr></table>
<h3>Sommaire</h3>

    <p><code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code> reprsente un modle de
    programmation simple et bien connu pour les <a href="../filter.html">filtres</a>. Avec ce module, tout programme
    qui lit l'entre standard stdin et crit sur la sortie standard
    stdout (autrement dit une commande filtre de style Unix) peut
    servir de filtre pour Apache. Ce mcanisme de filtrage est beaucoup
    plus lent qu'un filtre spcialement crit pour
    l'API d'Apache et faisant partie intgrante du processus du serveur
    Apache, mais il prsente les avantages suivants :</p>

    <ul>
      <li>le modle de programmation est beaucoup plus simple</li>

      <li>tout langage de script ou de programmation peut tre utilis,
      pourvu qu'il permette au programme de lire l'entre standard et
      d'crire sur la sortie standard.</li>

      <li>on peut utiliser des programmes existants comme filtres Apache
      sans modification.</li>
    </ul>

    <p>Mme dans le cas o le niveau de performance est insuffisant pour
    une utilisation en production, on peut utiliser
    <code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code> comme prototype d'environnement pour
    les filtres.</p>

</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#extfilterdefine">ExtFilterDefine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#extfilteroptions">ExtFilterOptions</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_ext_filter">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_ext_filter">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../filter.html">Filtres</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>

    <h3>Gnrer du HTML  partir d'un autre type de
    contenu</h3>

      <pre class="prettyprint lang-config"># la directive de mod_ext_filter dfinissant un filtre
# permettant de mettre des fichiers text/c au format HTML en
# utilisant le programme externe /usr/bin/enscript, le type du
# fichier rsultant tant dfini  text/html
ExtFilterDefine c-to-html mode=output \
    intype=text/c outtype=text/html \
    cmd="/usr/bin/enscript --color -W html -Ec -o - -"

&lt;Directory "/export/home/trawick/apacheinst/htdocs/c"&gt;
    # directive de base permettant de traiter la sortie avec le
    # nouveau filtre
    SetOutputFilter c-to-html

    # directive de mod_mime dfinissant le type des fichiers dont
    # le nom possde l'extension .c  text/c
    AddType text/c .c
&lt;/Directory&gt;</pre>

    

    <h3>Implmentation d'un filtre de codage de
    contenu</h3>
      <p>Note : cet exemple avec gzip n'est fourni qu' titre
      d'illustration. Veuillez vous reporter  la documentation de
      <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> pour un exemple d'implmentation plus
      pratique.</p>

      <pre class="prettyprint lang-config"># la directive de mod_ext_filter qui dfinit le filtre externe
ExtFilterDefine gzip mode=output cmd=/bin/gzip

&lt;Location "/gzipped"&gt;

    # directive de base permettant de traiter la sortie avec le
  # filtre gzip
    SetOutputFilter gzip

    # la directive de mod_headers permettant d'ajouter le champ
  # d'en-tte "Content-Encoding: gzip"
    Header set Content-Encoding gzip
&lt;/Location&gt;</pre>


    

    <h3>Ralentissement du serveur</h3>
      <pre class="prettyprint lang-config"># directive de mod_ext_filter dfinissant un filtre qui fait
# passer tous les flux en sortie par la commande cat ; cat ne
# modifie rien ; elle ne fait que compliquer le cheminement des
# flux et consommer des ressources supplmentaires
       ExtFilterDefine slowdown mode=output cmd=/bin/cat \
ExtFilterDefine slowdown mode=output cmd=/bin/cat \
    preservescontentlength

&lt;Location "/"&gt;
    # directive de base permettant de traiter plusieurs fois la
    # sortie avec le filtre slowdown
    #
    SetOutputFilter slowdown;slowdown;slowdown
&lt;/Location&gt;</pre>

    

    <h3>Utilisation de sed pour remplacer du texte dans la
    rponse</h3>

      <pre class="prettyprint lang-config"># directive de mod_ext_filter dfinissant un filtre qui
# remplace du texte dans la rponse
#
ExtFilterDefine fixtext mode=output intype=text/html \
    cmd="/bin/sed s/verdana/arial/g"

&lt;Location "/"&gt;
    # directive de base permettant de traiter la sortie avec le
    # filtre fixtext
    SetOutputFilter fixtext
&lt;/Location&gt;</pre>


<div class="note">
<p>Vous pouvez aussi utiliser <code class="module"><a href="../mod/mod_substitute.html">mod_substitute</a></code> pour
effectuer le mme traitement sans avoir  invoquer un programme
externe.</p>
</div>      

    

    <h3>Tracer un autre filtre</h3>
      <pre class="prettyprint lang-config"># Trace les donnes lues et crites par mod_deflate pour un
# client particulier (IP 192.168.1.31) qui a des problmes de
# compression.
# Ce premier filtre va tracer ce qui entre dans mod_deflate.
ExtFilterDefine tracebefore \
    cmd="/bin/tracefilter.pl /tmp/tracebefore" \
    EnableEnv=trace_this_client

# Ce second filtre va tracer ce qui sort de mod_deflate.
# Notez que sans le paramtre ftype, le type de filtre par
# dfaut AP_FTYPE_RESOURCE placerait le filtre *avant*
# mod_deflate dans la chane de filtrage. Le fait d'affecter
#  ce paramtre une valeur numrique sensiblement suprieure 
# AP_FTYPE_CONTENT_SET permet de s'assurer que le filtre sera
# plac aprs mod_deflate.
ExtFilterDefine traceafter \
    cmd="/bin/tracefilter.pl /tmp/traceafter" \
    EnableEnv=trace_this_client ftype=21

&lt;Directory "/usr/local/docs"&gt;
    SetEnvIf Remote_Addr 192.168.1.31 trace_this_client
    SetOutputFilter tracebefore;deflate;traceafter
&lt;/Directory&gt;</pre>


      <div class="example"><h3>Voici le filtre qui trace les donnes :</h3><pre class="prettyprint lang-perl">#!/usr/local/bin/perl -w
use strict;

open(SAVE, "&gt;$ARGV[0]")
    or die "can't open $ARGV[0]: $?";

while (&lt;STDIN&gt;) {
    print SAVE $_;
    print $_;
}

close(SAVE);</pre>
</div>
    
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="extfilterdefine" id="extfilterdefine">Directive</a> <a name="ExtFilterDefine" id="ExtFilterDefine">ExtFilterDefine</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit un filtre externe</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ExtFilterDefine <var>nom_filtre</var> <var>paramtres</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ext_filter</td></tr>
</table>
    <p>La directive <code class="directive">ExtFilterDefine</code>
    dfinit les caractristiques d'un filtre externe, et en particulier
    le programme  excuter ainsi que ses arguments.</p>

    <p><var>nom_filtre</var> spcifie le nom du filtre en cours de
    dfinition. On peut ensuite utiliser ce nom pour rfrencer le
    filtre dans les directives <code class="directive"><a href="../mod/core.html#setoutputfilter">SetOutputFilter</a></code>. Il doit tre unique parmi les noms de
    tous les filtres enregistrs. <em>Pour le moment, aucune erreur
    n'est signale par l'API register-filter, si bien qu'un problme de
    noms dupliqus ne sera pas port  la connaissance de
    l'utilisateur.</em></p>

    <p>Viennent ensuite un ou plusieurs paramtres dans un ordre
    indfini, qui permettent de spcifier la commande externe  excuter
    et certaines autres caractristiques. Le seul paramtre obligatoire
    est <code>cmd=</code>. Voici la liste de ces paramtres :</p>

    <dl>
      <dt><code>cmd=<var>ligne de commande</var></code></dt>

      <dd>Le mot-cl <code>cmd=</code> spcifie la commande
      externe  excuter. Si la ligne de commande comporte des
      arguments, elle doit tre entoure de guillemets (par exemple
      <code>cmd="<var>/bin/mypgm</var> <var>arg1</var>
      <var>arg2</var>"</code>). Les guillemets habituels du shell ne
      sont pas ncessaires car le programme est lanc directement, sans
      passer par le shell. Les arguments du programme doivent tre
      spars par des espaces. Si un argument contient des espaces, ces
      derniers doivent tre chapps par un antislash '\'. Si un
      argument contient des antislashes '\', ces derniers doivent tre
      eux-mmes chapps par un antislash '\'. Outre les variables
      d'environnement CGI standards, les variables DOCUMENT_URI,
      DOCUMENT_PATH_INFO, et QUERY_STRING_UNESCAPED seront galement
      dfinies pour le programme.</dd>

      <dt><code>mode=<var>mode</var></code></dt>

      <dd>Utilisez <code>mode=output</code> (valeur par dfaut) pour les
      filtres qui traitent les rponses. Utilisez
      <code>mode=input</code> pour les filtres qui traitent les
      requtes. <code>mode=input</code> est disponible depuis la version
      2.1 d'Apache.</dd>

      <dt><code>intype=<var>type MIME</var></code></dt>

      <dd>Ce paramtre spcifie le type de mdium Internet
      (c'est  dire le type MIME) des documents qui doivent tre
      filtrs. Par dfaut, tous les documents sont filtrs. Aucun des
      documents possdant un type MIME autre que celui spcifi par
      <code>intype=</code> ne sera filtr.</dd>

      <dt><code>outtype=<var>type MIME</var></code></dt>

      <dd>Ce paramtre spcifie le type de mdium Internet
      (c'est  dire le type MIME) des documents filtrs. Il intervient
      lorsque les oprations de filtrage comprennent une modification du
      type MIME. Par dfaut, le type MIME n'est pas modifi.</dd>

      <dt><code>PreservesContentLength</code></dt>

      <dd>Le mot-cl <code>PreservesContentLength</code> indique que le
      filtre doit conserver la taille du contenu. Ce n'est pas le
      comportement par dfaut, car la plupart des filtres modifient cette
      taille. Ce mot-cl doit tre spcifi si le filtre ne doit pas
      modifier la taille du contenu.</dd>

      <dt><code>ftype=<var>type de filtre</var></code></dt>

      <dd>Ce paramtre spcifie une valeur numrique
      reprsentant le type de filtre sous lequel le filtre doit tre
      enregistr. La valeur par dfaut, AP_FTYPE_RESOURCE, convient dans
      la plupart des situations. Ce paramtre devient ncessaire ds lors
      que le filtre doit oprer  un autre point de la chane de filtrage
      que les filtres de ressources.
      Voir les dfinitions de AP_FTYPE_...
      dans util_filter.h pour trouver une valeur approprie.</dd>

      <dt><code>disableenv=<var>env</var></code></dt>

      <dd>Ce paramtre spcifie le nom d'une variable
      d'environnement qui, si elle est dfinie, va dsactiver le
      filtre.</dd>

      <dt><code>enableenv=<var>env</var></code></dt>

      <dd>Ce paramtre spcifie le nom d'une variable
      d'environnement qui doit tre dfinie pour que le filtre ne soit
      pas dsactiv.</dd>
    </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="extfilteroptions" id="extfilteroptions">Directive</a> <a name="ExtFilterOptions" id="ExtFilterOptions">ExtFilterOptions</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure les options de
<code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code></td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ExtFilterOptions <var>option</var> [<var>option</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ExtFilterOptions NoLogStderr</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_ext_filter</td></tr>
</table>
    <p>La directive <code class="directive">ExtFilterOptions</code>
    spcifie des options de traitement particulires pour
    <code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code>. Les arguments <var>option</var>
    peuvent contenir :</p>

    <dl>
      <dt><code>LogStderr | NoLogStderr</code></dt>

      <dd>Le mot-cl <code>LogStderr</code> indique que les messages
      envoys par le programme de filtrage externe sur la sortie
      d'erreurs standard doivent tre enregistrs dans le journal des
      erreurs d'Apache. <code>NoLogStderr</code> inverse ce
      comportement.</dd>

      <dt><code>Onfail=[abort|remove]</code></dt>
      <dd>Indique la marche  suivre si le programme de filtrage externe
      ne peut pas dmarrer. Avec <code>abort</code> (la valeur par
      dfaut), le traitement de la requte sera abandonn. Avec <code>remove</code>, le
      filtre est supprim, et le traitement de la requte se poursuit
      sans lui.</dd>
    </dl>

    <pre class="prettyprint lang-config">ExtFilterOptions LogStderr</pre>


    <p>Les messages envoys vers la sortie d'erreurs standard du filtre
    seront enregistrs dans le journal des erreurs d'Apache.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_ext_filter.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_ext_filter.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_ext_filter.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_ext_filter.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_ext_filter.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>