"""\
Code generator functions for wxSpinButton objects

@copyright: 2004 D.H. aka crazyinsomniac at users.sourceforge.net
@copyright: 2014 Carsten Grohmann
@license: MIT (see license.txt) - THIS PROGRAM COMES WITH NO WARRANTY
"""

import common
import wcodegen


class PythonSpinButtonGenerator(wcodegen.PythonWidgetCodeWriter):
    tmpl = '%(name)s = %(klass)s(%(parent)s, %(id)s %(style)s)\n'

# end of class PythonSpinButtonGenerator


class CppSpinButtonGenerator(wcodegen.CppWidgetCodeWriter):
    extra_headers = ['<wx/spinbutt.h>']
    tmpl = '%(name)s = new %(klass)s(%(parent)s, %(id)s%(style)s);\n'

    def get_events(self, obj):
        return self.codegen.get_events_with_type(obj, 'wxSpinEvent')

# end of class CppSpinButtonGenerator


def xrc_code_generator(obj):
    xrcgen = common.code_writers['XRC']

    class SpinButtonXrcObject(xrcgen.DefaultXrcObject):
        def write_property(self, name, val, outfile, tabs):
            if name == 'range':
                try:
                    min, max = val.split(',')
                except ValueError:
                    pass
                else:
                    tab_s = '    ' * tabs
                    outfile.write(tab_s + '<min>%s</min>\n' % min)
                    outfile.write(tab_s + '<max>%s</max>\n' % max)
            else:
                xrcgen.DefaultXrcObject.write_property(self, name, val,
                                                       outfile, tabs)

    # end of class SpinButtonXrcObject

    return SpinButtonXrcObject(obj)


def initialize():
    klass = 'wxSpinButton'
    common.class_names['EditSpinButton'] = klass
    common.register('python', klass, PythonSpinButtonGenerator(klass))
    common.register('C++', klass, CppSpinButtonGenerator(klass))
    common.register('XRC', klass, xrc_code_generator)
