###############################################################################
#
# EagleCmdlets.ps1 --
#
# Extensible Adaptable Generalized Logic Engine (Eagle)
# PowerShell Cmdlet Installation Script
#
# Copyright (c) 2007-2012 by Joe Mistachkin.  All rights reserved.
#
# See the file "license.terms" for information on usage and redistribution of
# this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: $
#
###############################################################################

param([String]$mode)

$version = "v" + [System.Environment]::Version.ToString(3)

if ([IntPtr]::Size -eq 8) {
  Set-Alias InstallUtil `
      "$env:windir\Microsoft.NET\Framework64\$version\InstallUtil.exe"
} else {
  Set-Alias InstallUtil `
      "$env:windir\Microsoft.NET\Framework\$version\InstallUtil.exe"
}

$path = Split-Path $myInvocation.myCommand.path

if ($path -eq $null) {
  $path = "."
}

$fileName = Join-Path $path EagleCmdlets.dll

switch ($mode)
{
  "install" {
    InstallUtil /LogFile= $fileName

    if ($lastExitCode -eq 0) {
      Add-PSSnapin EagleCmdlets
    } else {
      Write-Error "Installation failed."
    }
  }
  "uninstall" {
    InstallUtil /u /LogFile= $fileName

    if ($lastExitCode -ne 0) {
      Write-Error "Uninstallation failed."
    }
  }
  default {
    Write-Error "Unknown mode."
  }
}
