/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.epic.core.Perspective;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.SourceLocator;
import org.epic.debug.util.CygwinPathMapper;
import org.epic.debug.util.IPathMapper;
import org.epic.debug.util.NullPathMapper;
import org.epic.perleditor.PerlEditorPlugin;

public abstract class LaunchConfigurationDelegate
extends org.eclipse.debug.core.model.LaunchConfigurationDelegate {
    public final void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        launch.setSourceLocator((ISourceLocator)new SourceLocator());
        this.doLaunch(configuration, mode, launch, monitor);
        if (launch.getLaunchMode().equals("debug")) {
            Perspective.switchPerspective((String)"org.eclipse.debug.ui.DebugPerspective");
        }
    }

    protected abstract void doLaunch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected IPathMapper getPathMapper(ILaunch launch) throws CoreException {
        if (this.isCygwin()) {
            return new CygwinPathMapper();
        }
        return new NullPathMapper();
    }

    protected IProject getProject(ILaunch launch) throws CoreException {
        String projectName = launch.getLaunchConfiguration().getAttribute("ATTR_PROJECT_NAME", "");
        return PerlDebugPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    protected final IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) {
        try {
            String prjName = configuration.getAttribute("ATTR_PROJECT_NAME", null);
            IProject[] p = new IProject[]{PerlDebugPlugin.getWorkspace().getRoot().getProject(prjName)};
            return p;
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return null;
        }
    }

    protected final boolean isCygwin() {
        String interpreterType = PerlEditorPlugin.getDefault().getPreferenceStore().getString("INTERPRETER_TYPE");
        return "Cygwin".equals(interpreterType);
    }

    protected final boolean isDebugMode(ILaunch launch) {
        return launch.getLaunchMode().equals("debug");
    }
}

