/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.PerlDB;

public class PerlDebugThread
extends DebugElement
implements IThread {
    private String mName;
    private IDebugTarget mDebugTarget;
    private ILaunch mLaunch;
    private PerlDB mPerlDB;
    private IStackFrame[] mFrames;
    private static final IBreakpoint[] mNoBreakpoints = new IBreakpoint[1];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PerlDebugThread(String name, ILaunch launch, IDebugTarget debugTarget, PerlDB fPerlDB) {
        super(debugTarget);
        this.mName = name;
        this.mDebugTarget = debugTarget;
        this.mLaunch = launch;
        this.mFrames = null;
        this.mPerlDB = fPerlDB;
        this.fireCreationEvent();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.mFrames;
    }

    public void setStackFrames(IStackFrame[] fFrames) {
        this.mFrames = fFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.mFrames != null ? this.mFrames[0] != null && this.isSuspended() : false;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return this.mFrames != null ? this.mFrames[0] : null;
    }

    public String getName() throws DebugException {
        if (this.isSuspended()) {
            return "<suspended>" + this.mName;
        }
        if (!this.isTerminated()) {
            return "<running>" + this.mName;
        }
        return this.mName;
    }

    public IBreakpoint[] getBreakpoints() {
        return mNoBreakpoints;
    }

    public String getModelIdentifier() {
        return PerlDebugPlugin.getUniqueIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.mDebugTarget;
    }

    public ILaunch getLaunch() {
        return this.mLaunch;
    }

    public boolean canResume() {
        return this.mPerlDB.canResume((IDebugElement)this);
    }

    public boolean canSuspend() {
        return this.mPerlDB.canSuspend((IDebugElement)this);
    }

    public boolean isSuspended() {
        return this.mPerlDB.isSuspended((IDebugElement)this);
    }

    public void resume() throws DebugException {
        this.mPerlDB.resume((IDebugElement)this);
    }

    public void suspend() throws DebugException {
        this.mPerlDB.suspend((IDebugElement)this);
    }

    public boolean canStepInto() {
        return this.mPerlDB.canStepInto((IDebugElement)this);
    }

    public boolean canStepOver() {
        return this.mPerlDB.canStepOver((IDebugElement)this);
    }

    public boolean canStepReturn() {
        return this.mPerlDB.canStepReturn((IDebugElement)this);
    }

    public boolean isStepping() {
        return this.mPerlDB.isStepping((IDebugElement)this);
    }

    public void stepInto() throws DebugException {
        this.mPerlDB.stepInto((IDebugElement)this);
    }

    public void stepOver() throws DebugException {
        this.mPerlDB.stepOver((IDebugElement)this);
    }

    public void stepReturn() throws DebugException {
        this.mPerlDB.stepReturn((IDebugElement)this);
    }

    public boolean canTerminate() {
        return this.mPerlDB.canTerminate((IDebugElement)this);
    }

    public boolean isTerminated() {
        return this.mPerlDB.isTerminated((IDebugElement)this);
    }

    public void terminate() throws DebugException {
        this.mPerlDB.terminate();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.PerlDebugThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        return super.getAdapter(adapter);
    }

    public PerlDB getPerlDB() {
        return this.mPerlDB;
    }
}

