/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.epic.debug.PerlDebugPlugin;

public class ArgumentsBlock
extends AbstractLaunchConfigurationTab {
    private final String fTitle;
    private final String fLaunchConfigAttr;
    private Text fPerlArgumentsText;
    private Button fPerlArgVariableButton;

    public ArgumentsBlock(String title, String launchConfigAttr) {
        this.fTitle = title;
        this.fLaunchConfigAttr = launchConfigAttr;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        this.setControl((Control)group);
        GridLayout topLayout = new GridLayout();
        group.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        group.setText(this.fTitle);
        this.fPerlArgumentsText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fPerlArgumentsText.setLayoutData((Object)gd);
        this.fPerlArgumentsText.setFont(font);
        this.fPerlArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ArgumentsBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this.fPerlArgVariableButton = this.createPushButton((Composite)group, "Varia&bles...", null);
        this.fPerlArgVariableButton.setFont(font);
        this.fPerlArgVariableButton.setLayoutData((Object)new GridData(128));
        this.fPerlArgVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ArgumentsBlock.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ArgumentsBlock.this.fPerlArgumentsText.insert(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.fLaunchConfigAttr, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPerlArgumentsText.setText(configuration.getAttribute(this.fLaunchConfigAttr, ""));
        }
        catch (CoreException e) {
            this.setErrorMessage("Exception occurred reading configuration:" + e.getStatus().getMessage());
            PerlDebugPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.fLaunchConfigAttr, this.getAttributeValueFrom(this.fPerlArgumentsText));
    }

    public String getName() {
        return "Perl Arguments";
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        return content.length() > 0 ? content : null;
    }

    public void setEnabled(boolean enabled) {
        this.fPerlArgumentsText.setEnabled(enabled);
        this.fPerlArgVariableButton.setEnabled(enabled);
    }
}

