/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.util;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.core.InputStreamMonitor;
import org.epic.debug.db.PerlDB;
import org.epic.debug.util.OutputStreamMonitor;
import org.epic.debug.util.RemotePort;

public class DebuggerProxy
extends PlatformObject
implements IProcess,
ITerminate,
IStreamsProxy {
    private OutputStreamMonitor mMonitorError;
    private OutputStreamMonitor mMonitorOut;
    private InputStreamMonitor mMonitorIn;
    private PrintWriter mOut;
    private ILaunch mLaunch;
    private PerlDB mDebugger;
    private String mLabel;
    private RemotePort mIOStream;
    private RemotePort mErrorStream;
    private boolean mShutDown;
    private final String ioHost;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DebuggerProxy(String fLabel, ILaunch fLaunch, String ioHost) {
        this.mLabel = fLabel;
        this.mLaunch = fLaunch;
        this.ioHost = ioHost;
        this.create();
        this.mIOStream = new RemotePort("DebuggerProxy.mIOStream");
        this.mIOStream.startConnect();
        this.mErrorStream = new RemotePort("DebuggerProxy.mErrorStream");
        this.mErrorStream.startConnect();
    }

    public void init(PerlDB fDebugger) throws CoreException {
        this.mDebugger = fDebugger;
        this.mLaunch = fDebugger.getLaunch();
        if (this.mIOStream.waitForConnect(true) != 1) {
            this.throwCouldNotConnect();
        }
        if (this.mErrorStream.waitForConnect(true) != 1) {
            this.throwCouldNotConnect();
        }
        this.mMonitorIn = new InputStreamMonitor(this.mIOStream.getOutStream());
        this.mMonitorOut.setStream(this.mIOStream.getInStream());
        this.mMonitorError.setStream(this.mErrorStream.getInStream());
        this.mMonitorIn.startMonitoring();
        this.mMonitorOut.startMonitoring();
        this.mMonitorError.startMonitoring();
        this.mOut = this.mIOStream.getWriteStream();
        this.mLabel = "Remote Perl Script";
    }

    public int getErrorPort() {
        return this.mErrorStream.getServerPort();
    }

    public String getIOHost() {
        return this.ioHost;
    }

    public int getIOPort() {
        return this.mIOStream.getServerPort();
    }

    public String getLabel() {
        return this.mLabel;
    }

    public ILaunch getLaunch() {
        return this.mLaunch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this;
    }

    public void setAttribute(String key, String value) {
        this.mLaunch.setAttribute(key, value);
    }

    public String getAttribute(String key) {
        return this.mLaunch.getAttribute(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IProcess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            IDebugTarget[] targets = this.getLaunch().getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public boolean canTerminate() {
        if (this.mDebugger == null) {
            return !this.mShutDown;
        }
        return this.mDebugger.canTerminate();
    }

    public boolean isTerminated() {
        if (this.mDebugger == null) {
            return !this.canTerminate();
        }
        return this.mDebugger.isTerminated();
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.mMonitorError;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.mMonitorOut;
    }

    public void terminate() throws DebugException {
        if (this.mDebugger != null) {
            this.mDebugger.terminate();
        }
        this.shutdown();
    }

    public void write(String input) throws IOException {
        if (this.mOut != null) {
            this.mOut.print(input);
        }
    }

    private void create() {
        this.mMonitorOut = new OutputStreamMonitor();
        this.mMonitorError = new OutputStreamMonitor();
        this.fireCreationEvent();
    }

    private void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    private void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    private void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    private void shutdown() {
        this.mShutDown = true;
        if (this.mMonitorError != null) {
            this.mMonitorError.kill();
        }
        if (this.mMonitorOut != null) {
            this.mMonitorOut.kill();
        }
        if (this.mMonitorIn != null) {
            this.mMonitorIn.close();
        }
        if (this.mMonitorOut != null) {
            this.mMonitorOut.close();
        }
        if (this.mIOStream != null) {
            this.mIOStream.shutdown();
        }
        if (this.mErrorStream != null) {
            this.mErrorStream.shutdown();
        }
        this.fireTerminateEvent();
    }

    private void throwCouldNotConnect() throws CoreException {
        throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 0, "Timed out while waiting for IO redirect from the debugged process", null));
    }
}

