/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.parser;

import antlr.CharStreamException;
import antlr.InputBuffer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

class DocumentInputBuffer
extends InputBuffer {
    private final IDocument doc;
    private final int len;

    public DocumentInputBuffer(IDocument doc, int startOffset) {
        this.doc = doc;
        this.len = doc.getLength();
        this.markerOffset = startOffset - 1;
    }

    public void commit() {
        --this.nMarkers;
    }

    public void consume() {
        ++this.markerOffset;
    }

    public String getLAChars() {
        throw new RuntimeException("unexpected method invocation");
    }

    public String getMarkedChars() {
        throw new RuntimeException("unexpected method invocation");
    }

    public boolean isMarked() {
        return this.nMarkers != 0;
    }

    public char LA(int i) throws CharStreamException {
        try {
            char c;
            char c2 = c = this.markerOffset + i < this.len ? (char)this.doc.getChar(this.markerOffset + i) : (char)'\uffff';
            if (c == '\ufffd') {
                throw new CharStreamException("unrecognized character at document offset " + (this.markerOffset + i));
            }
            return c;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void fill(int amount) throws CharStreamException {
    }

    public int mark() {
        ++this.nMarkers;
        return this.markerOffset;
    }

    public void rewind(int mark) {
        this.syncConsume();
        this.markerOffset = mark;
        --this.nMarkers;
    }

    public void reset() {
        this.nMarkers = 0;
        this.markerOffset = -1;
    }
}

