/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.popupmenus;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.epic.core.util.NatureUtilities;

public class TogglePerlNatureActionDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private IProject project = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        IStructuredSelection sel;
        Object firstElement;
        this.part = targetPart;
        ISelection selection = this.part.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            try {
                this.project = (IProject)firstElement;
                if (this.project.isAccessible()) {
                    if (this.project.hasNature("org.epic.perleditor.perlnature")) {
                        action.setText("Remove Perl Nature");
                    } else {
                        action.setText("Add Perl Nature");
                    }
                }
                action.setEnabled(this.project.isAccessible());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void run(IAction action) {
        if (this.project != null) {
            try {
                if (this.project.isAccessible()) {
                    if (this.project.hasNature("org.epic.perleditor.perlnature")) {
                        NatureUtilities.removeNature(this.project, "org.epic.perleditor.perlnature");
                    } else {
                        NatureUtilities.addNature(this.project, "org.epic.perleditor.perlnature");
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

