/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.epic.core.model.IMultilineElement;
import org.epic.core.model.SourceFile;
import org.epic.core.util.StatusFactory;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PerlEditor;

public class FoldReconciler {
    private final PerlEditor editor;
    private final Set folds;
    private boolean initialized = false;
    static /* synthetic */ Class class$0;

    public FoldReconciler(PerlEditor editor) {
        this.editor = editor;
        this.folds = new HashSet();
    }

    public void reconcile() {
        if (!this.isFoldingEnabled()) {
            return;
        }
        try {
            IAnnotationModel annotations = this.getAnnotations();
            if (annotations == null) {
                return;
            }
            Set tuples = this.computeFoldPositions();
            this.removeFolds(tuples);
            this.addFolds(tuples);
            this.initialized = true;
        }
        catch (BadLocationException e) {
            String pluginId = PerlEditorPlugin.getPluginId();
            this.getLog().log(StatusFactory.createError(pluginId, "Unexpected exception; report it as a bug in plug-in " + pluginId, e));
        }
    }

    protected ILog getLog() {
        return PerlEditorPlugin.getDefault().getLog();
    }

    protected SourceFile getSourceFile() {
        return this.editor.getSourceFile();
    }

    private void addFolds(Set tuples) {
        Iterator iter = tuples.iterator();
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            if (this.folds.contains(t)) continue;
            this.getAnnotations().addAnnotation(t.annotation, t.position);
            this.folds.add(t);
        }
    }

    private Set computeFoldPositions() throws BadLocationException {
        HashSet tuples = new HashSet();
        this.computeFoldPositions(tuples, this.getSourceFile().getPODs(), this.initialized ? false : this.isFoldPerldoc());
        this.computeFoldPositions(tuples, this.getSourceFile().getSubs(), this.initialized ? false : this.isFoldSubroutines());
        return tuples;
    }

    private void computeFoldPositions(Set tuples, Iterator elements, boolean collapse) throws BadLocationException {
        IDocument doc = this.getSourceFile().getDocument();
        while (elements.hasNext()) {
            IMultilineElement e = (IMultilineElement)elements.next();
            if (e.getStartLine() == e.getEndLine()) continue;
            int offset = doc.getLineOffset(e.getStartLine());
            int length = doc.getLineOffset(e.getEndLine()) - offset + doc.getLineLength(e.getEndLine());
            Tuple t = new Tuple(new Position(offset, length), (Annotation)new ProjectionAnnotation(collapse));
            tuples.add(t);
        }
    }

    protected IAnnotationModel getAnnotations() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IAnnotationModel)this.editor.getAdapter(clazz);
    }

    protected boolean getPreference(String name) {
        IPreferenceStore store = PerlEditorPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(name);
    }

    private boolean isFoldingEnabled() {
        return this.getPreference("sourceFolding");
    }

    private boolean isFoldPerldoc() {
        return this.getPreference("sourceFolding.perldoc");
    }

    private boolean isFoldSubroutines() {
        return this.getPreference("sourceFolding.subroutine");
    }

    private void removeFolds(Set toRemove) {
        Iterator iter = this.folds.iterator();
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            Position p = this.getAnnotations().getPosition(t.annotation);
            if (p != null && (p.isDeleted() || !toRemove.contains(t))) {
                this.getAnnotations().removeAnnotation(t.annotation);
                iter.remove();
                continue;
            }
            toRemove.remove(t);
        }
    }

    private class Tuple {
        Annotation annotation;
        Position position;

        Tuple(Position p, Annotation a) {
            this.position = p;
            this.annotation = a;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tuple other = (Tuple)obj;
            return !(this.position == null ? other.position != null : !this.position.equals((Object)other.position));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
            return result;
        }
    }
}

