/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.perl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.epic.perleditor.templates.TemplateContext;
import org.epic.perleditor.templates.TemplateMessages;
import org.epic.perleditor.templates.perl.IPerlCompletionProposal;
import org.epic.perleditor.templates.perl.PerlUnitContext;
import org.epic.perleditor.templates.ui.LinkedPositionManager;
import org.epic.perleditor.templates.ui.LinkedPositionUI;

public class SubroutineProposal
implements IPerlCompletionProposal {
    private final String fTemplate;
    private final TemplateContext fContext;
    private final ITextViewer fViewer;
    private final Image fImage_fun;
    private final Image fImage_var;
    private final IRegion fRegion;
    private String fOldText;
    private IRegion fSelectedRegion;

    public SubroutineProposal(String template, TemplateContext context, IRegion region, ITextViewer viewer, Image image_fun, Image image_var) {
        this.fTemplate = template;
        this.fContext = context;
        this.fViewer = viewer;
        this.fImage_fun = image_fun;
        this.fImage_var = image_var;
        this.fRegion = region;
    }

    public void apply(IDocument document) {
        try {
            int start = this.fRegion.getOffset();
            int end = this.fRegion.getOffset() + this.fRegion.getLength();
            document.replace(start, end - start, this.fTemplate);
            LinkedPositionManager manager = new LinkedPositionManager(document);
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            editor.setFinalCaretOffset(this.fTemplate.length() + start);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            this.openErrorDialog(e);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.fTemplate;
    }

    public Image getImage() {
        if (this.fTemplate.charAt(0) == '$') {
            return this.fImage_var;
        }
        return this.fImage_fun;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private static String textToHTML(String string) {
        StringBuffer buffer = new StringBuffer(string.length());
        buffer.append("<pre>");
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\t': {
                    buffer.append("    ");
                    break;
                }
                case '\n': {
                    buffer.append("<br>");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        buffer.append("</pre>");
        return buffer.toString();
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    private void handleException(CoreException e) {
        this.fViewer.getTextWidget().getShell();
        e.printStackTrace();
    }

    public int getRelevance() {
        if (this.fContext instanceof PerlUnitContext) {
            PerlUnitContext context = (PerlUnitContext)this.fContext;
            switch (context.getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return 90;
                }
            }
            return 0;
        }
        return 90;
    }
}

