/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.views;

import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.epic.core.model.SourceFile;
import org.epic.core.model.Subroutine;
import org.epic.perleditor.views.PerlOutlineContentProvider;
import org.epic.perleditor.views.PerlOutlineLabelProvider;

public class PerlOutlinePage
extends ContentOutlinePage {
    private SourceFile source;
    private Subroutine lastCaretSub;

    public PerlOutlinePage(SourceFile source) {
        this.source = source;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new PerlOutlineContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PerlOutlineLabelProvider());
        viewer.setSorter(new ViewerSorter());
        viewer.setInput((Object)this.source);
        viewer.expandAll();
    }

    public void updateContent(SourceFile source) {
        this.lastCaretSub = null;
        if (!source.equals(this.source)) {
            this.source = source;
            this.getTreeViewer().setInput((Object)source);
        }
    }

    public void updateSelection(int caretLine) {
        if (this.lastCaretSub == null || caretLine < this.lastCaretSub.getStartLine() || caretLine > this.lastCaretSub.getEndLine()) {
            this.lastCaretSub = null;
            Iterator i = this.source.getSubs();
            while (i.hasNext()) {
                Subroutine sub = (Subroutine)i.next();
                if (caretLine < sub.getStartLine() || caretLine > sub.getEndLine()) continue;
                this.lastCaretSub = sub;
                break;
            }
        }
        if (this.lastCaretSub != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)this.lastCaretSub));
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }
}

