/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.ImageDescriptorRegistry;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.symbols.ISymbolFinder;
import org.rubypeople.rdt.internal.core.util.EclipseJobScheduler;
import org.rubypeople.rdt.internal.core.util.IJobScheduler;
import org.rubypeople.rdt.internal.formatter.OldCodeFormatter;
import org.rubypeople.rdt.internal.ui.ProjectUpgradeListener;
import org.rubypeople.rdt.internal.ui.RubyFileMatcher;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.rubypeople.rdt.internal.ui.preferences.MockupPreferenceStore;
import org.rubypeople.rdt.internal.ui.rdocexport.RDocUtility;
import org.rubypeople.rdt.internal.ui.rubyeditor.DocumentAdapter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyDocumentProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;
import org.rubypeople.rdt.internal.ui.symbols.BlockingSymbolFinder;
import org.rubypeople.rdt.internal.ui.text.IRubyColorConstants;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;
import org.rubypeople.rdt.internal.ui.text.folding.RubyFoldingStructureProviderRegistry;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.RubyTemplateAccess;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class RubyPlugin
extends AbstractUIPlugin
implements IRubyColorConstants {
    private static final String ORG_ECLIPSE_UI_VIEWS_TASK_LIST = "org.eclipse.ui.views.TaskList";
    private static final String ORG_ECLIPSE_UI_VIEWS_PROBLEM_VIEW = "org.eclipse.ui.views.ProblemView";
    protected static RubyPlugin plugin;
    public static final String PLUGIN_ID = "org.rubypeople.rdt.ui";
    protected RubyTextTools textTools;
    protected RubyFileMatcher rubyFileMatcher;
    private IWorkingCopyManager fWorkingCopyManager;
    private RubyDocumentProvider fDocumentProvider;
    private IPreferenceStore fCombinedPreferenceStore;
    private MockupPreferenceStore fMockupPreferenceStore;
    private RubyFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private boolean new060ViewsOpened;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    static /* synthetic */ Class class$0;

    public RubyPlugin() {
        plugin = this;
    }

    public MockupPreferenceStore getMockupPreferenceStore() {
        if (this.fMockupPreferenceStore == null) {
            this.fMockupPreferenceStore = new MockupPreferenceStore();
        }
        return this.fMockupPreferenceStore;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(IRubyScript iRubyScript) {
                IRubyScript iRubyScript2 = iRubyScript.getPrimary();
                IResource iResource = iRubyScript2.getResource();
                if (iResource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)iRubyScript, (IFile)iResource);
                }
                return DocumentAdapter.NULL;
            }
        });
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        this.fMembersOrderPreferenceCache.install(iPreferenceStore);
        RubyCore rubyCore = RubyCore.getPlugin();
        BlockingSymbolFinder blockingSymbolFinder = new BlockingSymbolFinder(rubyCore.getSymbolFinder(), (IJobScheduler)new EclipseJobScheduler());
        rubyCore.setSymbolFinder((ISymbolFinder)blockingSymbolFinder);
        this.listenForNewProjects();
        this.upgradeOldProjects();
        String string = Platform.getDebugOption((String)"org.rubypeople.rdt.ui/generaterdoc");
        RDocUtility.setDebugging(string == null ? false : string.equalsIgnoreCase("true"));
    }

    private void listenForNewProjects() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ProjectUpgradeListener(this));
    }

    void upgradeOldProjects() {
        Job job = new Job("Upgrade Old Ruby Projects"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    boolean bl = RubyCore.upgradeOldProjects();
                    if (bl) {
                        RubyPlugin.this.openNew060Views();
                    }
                }
                catch (CoreException coreException) {
                    RubyPlugin.log(2, "While upgrading RDT projects", coreException);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void openNew060Views() {
        if (this.new060ViewsOpened) {
            return;
        }
        WorkbenchJob workbenchJob = new WorkbenchJob("Show Task View"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                try {
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                        iWorkbenchPage.showView(RubyPlugin.ORG_ECLIPSE_UI_VIEWS_TASK_LIST);
                        iWorkbenchPage.showView(RubyPlugin.ORG_ECLIPSE_UI_VIEWS_PROBLEM_VIEW);
                        RubyPlugin.this.new060ViewsOpened = true;
                    }
                }
                catch (PartInitException partInitException) {}
                return Status.OK_STATUS;
            }
        };
        workbenchJob.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.shutdown();
                this.fWorkingCopyManager = null;
            }
            if (this.fDocumentProvider != null) {
                this.fDocumentProvider.shutdown();
                this.fDocumentProvider = null;
            }
            if (this.textTools != null) {
                this.textTools.dispose();
                this.textTools = null;
            }
            if (this.fMembersOrderPreferenceCache != null) {
                this.fMembersOrderPreferenceCache.dispose();
                this.fMembersOrderPreferenceCache = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(bundleContext);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(bundleContext);
    }

    public static void log(String string) {
        RubyPlugin.log(0, string);
    }

    public static RubyPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return RubyCore.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return RubyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void log(IStatus iStatus) {
        RubyPlugin.getDefault().getLog().log(iStatus);
        System.out.println(iStatus.getMessage());
        if (iStatus.getException() != null) {
            iStatus.getException().printStackTrace();
        }
    }

    public static void log(Throwable throwable) {
        RubyPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, RubyUIMessages.getString("RdtUiPlugin.internalErrorOccurred"), throwable));
    }

    public static void log(int n, String string, Throwable throwable) {
        Status status = new Status(n, PLUGIN_ID, 0, string, throwable);
        RubyPlugin.log((IStatus)status);
    }

    public static Shell getActiveWorkbenchShell() {
        return RubyPlugin.getActiveWorkbenchWindow().getShell();
    }

    public synchronized RubyTextTools getRubyTextTools() {
        if (this.textTools == null) {
            this.textTools = new RubyTextTools(this.getPreferenceStore(), RubyCore.getPlugin().getPluginPreferences());
        }
        return this.textTools;
    }

    public OldCodeFormatter getCodeFormatter() {
        return new OldCodeFormatter((Map)RubyCore.getOptions());
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_default", (RGB)new RGB(0, 0, 0));
        iPreferenceStore.setDefault("color_ruby_default_bold", false);
        iPreferenceStore.setDefault("color_ruby_default_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_keyword", (RGB)new RGB(164, 53, 122));
        iPreferenceStore.setDefault("color_ruby_keyword_bold", true);
        iPreferenceStore.setDefault("color_ruby_keyword_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_string", (RGB)new RGB(42, 0, 255));
        iPreferenceStore.setDefault("color_ruby_string_bold", false);
        iPreferenceStore.setDefault("color_ruby_string_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_regexp", (RGB)new RGB(90, 30, 160));
        iPreferenceStore.setDefault("color_ruby_regexp_bold", false);
        iPreferenceStore.setDefault("color_ruby_regexp_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_command", (RGB)new RGB(0, 128, 128));
        iPreferenceStore.setDefault("color_ruby_command_bold", false);
        iPreferenceStore.setDefault("color_ruby_command_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_fixnum", (RGB)new RGB(0, 128, 255));
        iPreferenceStore.setDefault("color_ruby_fixnum_bold", true);
        iPreferenceStore.setDefault("color_ruby_fixnum_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_character", (RGB)new RGB(255, 128, 128));
        iPreferenceStore.setDefault("color_ruby_character_bold", true);
        iPreferenceStore.setDefault("color_ruby_character_italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_symbol", (RGB)new RGB(255, 64, 64));
        iPreferenceStore.setDefault("color_ruby_symbol_bold", true);
        iPreferenceStore.setDefault("color_ruby_symbol_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_instance_variable", (RGB)new RGB(0, 64, 128));
        iPreferenceStore.setDefault("color_ruby_instance_variable_bold", true);
        iPreferenceStore.setDefault("color_ruby_instance_variable_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_global", (RGB)new RGB(255, 0, 0));
        iPreferenceStore.setDefault("color_ruby_global_bold", false);
        iPreferenceStore.setDefault("color_ruby_global_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_multiline_comment", (RGB)new RGB(63, 127, 95));
        iPreferenceStore.setDefault("color_ruby_multiline_comment_bold", false);
        iPreferenceStore.setDefault("color_ruby_multiline_comment_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_singleline_comment", (RGB)new RGB(63, 127, 95));
        iPreferenceStore.setDefault("color_ruby_singleline_comment_bold", false);
        iPreferenceStore.setDefault("color_ruby_singleline_comment_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_task", (RGB)new RGB(127, 159, 191));
        iPreferenceStore.setDefault("color_ruby_task_bold", true);
        iPreferenceStore.setDefault("color_ruby_task_italic", false);
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)iPreferenceStore);
        EditorsUI.useQuickDiffPreferencePage((IPreferenceStore)iPreferenceStore);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"color_ruby_content_assistant_background", (RGB)new RGB(150, 150, 0));
        PreferenceConstants.initializeDefaultValues(iPreferenceStore);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = RubyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return RubyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public RubyFileMatcher getRubyFileMatcher() {
        if (this.rubyFileMatcher == null) {
            this.rubyFileMatcher = new RubyFileMatcher();
        }
        return this.rubyFileMatcher;
    }

    public IResource getSelectedResource() {
        IEditorPart iEditorPart;
        Object object;
        IWorkbenchPage iWorkbenchPage = RubyPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        ISelection iSelection = iWorkbenchPage.getSelection();
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty() && (object = (iEditorPart = (IStructuredSelection)iSelection).getFirstElement()) instanceof IResource) {
            return (IResource)object;
        }
        iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        object = iEditorPart.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IResource)object.getAdapter((Class)clazz);
    }

    public boolean isRubyFile(IFile iFile) {
        return this.getRubyFileMatcher().hasRubyEditorAssociation(iFile);
    }

    public boolean isRubyFile(IResource iResource) {
        if (iResource == null || !(iResource instanceof IFile)) {
            return false;
        }
        return this.isRubyFile((IFile)iResource);
    }

    public IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            RubyDocumentProvider rubyDocumentProvider = this.getRubyDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(rubyDocumentProvider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized RubyDocumentProvider getRubyDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new RubyDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public synchronized RubyFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new RubyFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(int n, String string) {
        RubyPlugin.log((IStatus)new Status(n, PLUGIN_ID, 0, string, null));
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(RubyCore.getPlugin().getPluginPreferences()), iPreferenceStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public static void logErrorMessage(String string) {
        RubyPlugin.log((IStatus)new Status(4, RubyPlugin.getPluginId(), 10001, string, null));
    }

    public TemplateStore getTemplateStore() {
        return RubyTemplateAccess.getDefault().getTemplateStore();
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        return RubyTemplateAccess.getDefault().getContextTypeRegistry();
    }

    public static boolean isDebug() {
        return false;
    }

    public static void createStandardGroups(IMenuManager iMenuManager) {
        if (!iMenuManager.isEmpty()) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator("group.new"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.goto"));
        iMenuManager.add((IContributionItem)new Separator("group.open"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.show"));
        iMenuManager.add((IContributionItem)new Separator("group.reorganize"));
        iMenuManager.add((IContributionItem)new Separator("group.generate"));
        iMenuManager.add((IContributionItem)new Separator("group.search"));
        iMenuManager.add((IContributionItem)new Separator("group.build"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("group.viewerSetup"));
        iMenuManager.add((IContributionItem)new Separator("group.properties"));
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return RubyPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        return this.fMembersOrderPreferenceCache;
    }
}

