/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;
import org.rubypeople.rdt.ui.IWorkingCopyManager;

public class TogglePresentationAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public TogglePresentationAction() {
        super(RubyEditorMessages.getBundleForConstructedKeys(), "TogglePresentation.", null, 2);
        RubyPluginImages.setToolImageDescriptors((IAction)this, "segment_edit.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.toggle_presentation_action_context");
        this.update();
    }

    public void run() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return;
        }
        IRegion iRegion = iTextEditor.getHighlightRange();
        iTextEditor.resetHighlightRange();
        boolean bl = !iTextEditor.showsHighlightRangeOnly();
        this.setChecked(bl);
        iTextEditor.showHighlightRangeOnly(bl);
        if (iRegion != null) {
            iTextEditor.setHighlightRange(iRegion.getOffset(), iRegion.getLength(), true);
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("org.rubypeople.rdt.ui.editor.showSegments", bl);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        ITextEditor iTextEditor = this.getTextEditor();
        boolean bl = iTextEditor != null && iTextEditor.showsHighlightRangeOnly();
        this.setChecked(bl);
        if (iTextEditor instanceof RubyEditor) {
            IWorkingCopyManager iWorkingCopyManager = RubyPlugin.getDefault().getWorkingCopyManager();
            this.setEnabled(iWorkingCopyManager.getWorkingCopy(iTextEditor.getEditorInput()) != null);
        } else {
            this.setEnabled(iTextEditor != null);
        }
    }

    public void setEditor(ITextEditor iTextEditor) {
        super.setEditor(iTextEditor);
        if (iTextEditor != null) {
            if (this.fStore == null) {
                this.fStore = RubyPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference(iTextEditor);
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    private void synchronizeWithPreference(ITextEditor iTextEditor) {
        if (iTextEditor == null) {
            return;
        }
        boolean bl = this.fStore.getBoolean("org.rubypeople.rdt.ui.editor.showSegments");
        this.setChecked(bl);
        if (iTextEditor.showsHighlightRangeOnly() != bl) {
            IRegion iRegion = iTextEditor.getHighlightRange();
            iTextEditor.resetHighlightRange();
            iTextEditor.showHighlightRangeOnly(bl);
            if (iRegion != null) {
                iTextEditor.setHighlightRange(iRegion.getOffset(), iRegion.getLength(), true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("org.rubypeople.rdt.ui.editor.showSegments")) {
            this.synchronizeWithPreference(this.getTextEditor());
        }
    }
}

