/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = RubyElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 2L;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager iStatusLineManager) {
        this.fStatusLineManager = iStatusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        String string = this.formatMessage(selectionChangedEvent.getSelection());
        this.fStatusLineManager.setMessage(string);
    }

    protected String formatMessage(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            int n = iStructuredSelection.size();
            if (n > 1) {
                return Messages.format(RubyUIMessages.StatusBarUpdater_num_elements_selected, String.valueOf(n));
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IRubyElement) {
                return this.formatRubyElementMessage((IRubyElement)object);
            }
            if (object instanceof IResource) {
                return this.formatResourceMessage((IResource)object);
            }
        }
        return "";
    }

    private String formatRubyElementMessage(IRubyElement iRubyElement) {
        return RubyElementLabels.getElementLabel(iRubyElement, this.LABEL_FLAGS);
    }

    private String formatResourceMessage(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (iContainer != null && iContainer.getType() != 8) {
            return String.valueOf(iResource.getName()) + RubyElementLabels.CONCAT_STRING + iContainer.getFullPath().makeRelative().toString();
        }
        return iResource.getName();
    }
}

