/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.actions.ActionUtil;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class OpenAction
extends SelectionDispatchAction {
    private RubyEditor fEditor;
    static /* synthetic */ Class class$0;

    public OpenAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.open_action");
    }

    public OpenAction(RubyEditor rubyEditor) {
        this((IWorkbenchSite)rubyEditor.getEditorSite());
        this.fEditor = rubyEditor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ISourceReference || e instanceof IFile || e instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            IRubyElement iRubyElement = SelectionConverter.codeResolve(this.fEditor, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element);
            if (iRubyElement == null) {
                IEditorStatusLine iEditorStatusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iEditorStatusLine = (IEditorStatusLine)this.fEditor.getAdapter(clazz)) != null) {
                    iEditorStatusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            IRubyElement iRubyElement2 = SelectionConverter.getInput(this.fEditor);
            int n = iRubyElement.getElementType();
            if (n == 1) {
                iRubyElement = iRubyElement2;
            }
            this.run(new Object[]{iRubyElement});
        }
        catch (RubyModelException rubyModelException) {
            this.showError((CoreException)((Object)rubyModelException));
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (!this.checkEnabled(iStructuredSelection)) {
            return;
        }
        this.run(iStructuredSelection.toArray());
    }

    public void run(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            block10: {
                Object object = objectArray[n];
                try {
                    object = this.getElementToOpen(object);
                    boolean bl = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open(object, bl);
                }
                catch (RubyModelException rubyModelException) {
                    RubyPlugin.log((IStatus)new Status(4, RubyPlugin.getPluginId(), 10001, ActionMessages.OpenAction_error_message, (Throwable)rubyModelException));
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_messageProblems, (IStatus)rubyModelException.getStatus());
                }
                catch (PartInitException partInitException) {
                    String string = null;
                    if (object instanceof IRubyElement) {
                        string = ((IRubyElement)object).getElementName();
                    } else if (object instanceof IStorage) {
                        string = ((IStorage)object).getName();
                    } else if (object instanceof IResource) {
                        string = ((IResource)object).getName();
                    }
                    if (string == null) break block10;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)Messages.format(ActionMessages.OpenAction_error_messageArgs, new String[]{string, partInitException.getMessage()}));
                }
            }
            ++n;
        }
    }

    public Object getElementToOpen(Object object) throws RubyModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }

    private void showError(CoreException coreException) {
        ExceptionHandler.handle(coreException, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
    }
}

