/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.launching.RdtLaunchingPlugin;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;
import org.rubypeople.rdt.internal.launching.RubyRuntime;

public class InterpreterRunnerConfiguration {
    protected ILaunchConfiguration configuration;

    public InterpreterRunnerConfiguration(ILaunchConfiguration iLaunchConfiguration) {
        this.configuration = iLaunchConfiguration;
    }

    public String getAbsoluteFileName() {
        IProject iProject = this.getProject().getProject();
        return String.valueOf(iProject.getLocation().toOSString()) + "/" + this.getFileName();
    }

    public String getAbsoluteFileDirectory() {
        Path path = new Path(this.getFileName());
        path = path.removeLastSegments(1);
        IProject iProject = this.getProject().getProject();
        return String.valueOf(iProject.getLocation().toOSString()) + File.separator + path.toOSString();
    }

    public String getFileName() {
        String string = "";
        try {
            string = this.configuration.getAttribute("org.rubypeople.rdt.launching.FILE_NAME", "No file specified in configuration");
        }
        catch (CoreException coreException) {}
        return string.replace('\\', '/');
    }

    public RubyProject getProject() {
        String string = "";
        try {
            string = this.configuration.getAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", "");
        }
        catch (CoreException coreException) {
            RdtLaunchingPlugin.log(coreException);
        }
        RubyProject rubyProject = new RubyProject();
        if (string.length() > 0) {
            IProject iProject = RdtLaunchingPlugin.getWorkspace().getRoot().getProject(string);
            rubyProject.setProject(iProject);
        }
        return rubyProject;
    }

    public File getAbsoluteWorkingDirectory() {
        String string = null;
        try {
            string = this.configuration.getAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", "");
        }
        catch (CoreException coreException) {
            RdtLaunchingPlugin.log(coreException);
        }
        return string == "" ? null : new File(string);
    }

    public String getInterpreterArguments() {
        try {
            return this.configuration.getAttribute("org.rubypeople.rdt.launching.INTERPRETER_ARGUMENTS", "");
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public String getProgramArguments() {
        try {
            return this.configuration.getAttribute("org.rubypeople.rdt.launching.PROGRAM_ARGUMENTS", "");
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public RubyInterpreter getInterpreter() {
        String string = null;
        try {
            string = this.configuration.getAttribute("org.rubypeople.rdt.launching.SELECTED_INTERPRETER", "");
        }
        catch (CoreException coreException) {}
        return RubyRuntime.getDefault().getInterpreter(string);
    }

    protected void addToLoadPath(List list, IProject iProject) {
        if (!iProject.isAccessible()) {
            return;
        }
        this.addToLoadPath(list, iProject.getLocation().toOSString());
    }

    private void addToLoadPath(List list, String string) {
        list.add("-I");
        list.add(RdtLaunchingPlugin.osDependentPath(string));
    }

    protected List renderLoadPath() {
        ArrayList arrayList = new ArrayList();
        RubyProject rubyProject = this.getProject();
        this.addToLoadPath(arrayList, rubyProject.getProject());
        Iterator iterator = rubyProject.getReferencedProjects().iterator();
        while (iterator.hasNext()) {
            this.addToLoadPath(arrayList, (IProject)iterator.next());
        }
        if (new Path(this.getFileName()).segmentCount() > 1) {
            this.addToLoadPath(arrayList, this.getAbsoluteFileDirectory());
        }
        return arrayList;
    }
}

