/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.internal.launching.RdtLaunchingPlugin;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RubyRuntime {
    protected static RubyRuntime runtime;
    protected List installedInterpreters;
    protected RubyInterpreter selectedInterpreter;
    private List listeners = new ArrayList();

    protected RubyRuntime() {
    }

    public static RubyRuntime getDefault() {
        if (runtime == null) {
            runtime = new RubyRuntime();
        }
        return runtime;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public RubyInterpreter getSelectedInterpreter() {
        if (this.selectedInterpreter == null) {
            this.loadRuntimeConfiguration();
        }
        return this.selectedInterpreter;
    }

    public RubyInterpreter getInterpreter(String string) {
        Iterator iterator = this.getInstalledInterpreters().iterator();
        while (iterator.hasNext()) {
            RubyInterpreter rubyInterpreter = (RubyInterpreter)iterator.next();
            if (!rubyInterpreter.getName().equals(string)) continue;
            return rubyInterpreter;
        }
        return this.getSelectedInterpreter();
    }

    public void setSelectedInterpreter(RubyInterpreter rubyInterpreter) {
        if (this.selectedInterpreter == rubyInterpreter) {
            return;
        }
        this.selectedInterpreter = rubyInterpreter;
        this.saveRuntimeConfiguration();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            listener.selectedInterpreterChanged();
        }
    }

    public void addInstalledInterpreter(RubyInterpreter rubyInterpreter) {
        this.getInstalledInterpreters().add(rubyInterpreter);
        if (this.getInstalledInterpreters().size() == 1) {
            this.setSelectedInterpreter((RubyInterpreter)this.getInstalledInterpreters().get(0));
        }
        this.saveRuntimeConfiguration();
    }

    public List getInstalledInterpreters() {
        if (this.installedInterpreters == null) {
            this.loadRuntimeConfiguration();
        }
        return this.installedInterpreters;
    }

    public void setInstalledInterpreters(List list) {
        this.installedInterpreters = list;
        if (this.installedInterpreters.size() > 0) {
            this.setSelectedInterpreter((RubyInterpreter)this.installedInterpreters.get(0));
        } else {
            this.setSelectedInterpreter(null);
        }
    }

    protected void saveRuntimeConfiguration() {
        this.writeXML(this.getRuntimeConfigurationWriter());
    }

    protected Writer getRuntimeConfigurationWriter() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getRuntimeConfigurationFile()));
            return new OutputStreamWriter(bufferedOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected void loadRuntimeConfiguration() {
        this.installedInterpreters = new ArrayList();
        try {
            XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this.getRuntimeConfigurationContentHandler());
            Reader reader = this.getRuntimeConfigurationReader();
            if (reader == null) {
                return;
            }
            xMLReader.parse(new InputSource(reader));
        }
        catch (Exception exception) {
            RdtLaunchingPlugin.log(exception);
        }
    }

    private void autoDetectRubyInterpreter() {
        Path path = null;
        path = Platform.getOS().equals("win32") ? new Path("/ruby/bin/ruby.exe") : new Path("/usr/local/bin/ruby");
        RubyInterpreter rubyInterpreter = new RubyInterpreter("Default Ruby Interpreter", (IPath)path);
        this.installedInterpreters.add(rubyInterpreter);
        this.selectedInterpreter = rubyInterpreter;
    }

    protected Reader getRuntimeConfigurationReader() {
        try {
            return new FileReader(this.getRuntimeConfigurationFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected void writeXML(Writer writer) {
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeconfig>");
            Iterator iterator = this.installedInterpreters.iterator();
            while (iterator.hasNext()) {
                writer.write("<interpreter name=\"");
                RubyInterpreter rubyInterpreter = (RubyInterpreter)iterator.next();
                writer.write(rubyInterpreter.getName());
                writer.write("\" path=\"");
                writer.write(rubyInterpreter.getInstallLocation().toString());
                writer.write("\"");
                if (rubyInterpreter.equals(this.selectedInterpreter)) {
                    writer.write(" selected=\"true\"");
                }
                writer.write("/>");
            }
            writer.write("</runtimeconfig>");
            writer.flush();
        }
        catch (IOException iOException) {
            RdtLaunchingPlugin.log(iOException);
        }
    }

    protected ContentHandler getRuntimeConfigurationContentHandler() {
        return new ContentHandler(){

            public void setDocumentLocator(Locator locator) {
            }

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startPrefixMapping(String string, String string2) throws SAXException {
            }

            public void endPrefixMapping(String string) throws SAXException {
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if ("interpreter".equals(string3)) {
                    String string4 = attributes.getValue("name");
                    Path path = new Path(attributes.getValue("path"));
                    RubyInterpreter rubyInterpreter = new RubyInterpreter(string4, (IPath)path);
                    RubyRuntime.this.installedInterpreters.add(rubyInterpreter);
                    if (attributes.getValue("selected") != null) {
                        RubyRuntime.this.selectedInterpreter = rubyInterpreter;
                    }
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
            }

            public void characters(char[] cArray, int n, int n2) throws SAXException {
            }

            public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            }

            public void processingInstruction(String string, String string2) throws SAXException {
            }

            public void skippedEntity(String string) throws SAXException {
            }
        };
    }

    protected File getRuntimeConfigurationFile() {
        IPath iPath = RdtLaunchingPlugin.getDefault().getStateLocation();
        IPath iPath2 = iPath.append("runtimeConfiguration.xml");
        return new File(iPath2.toOSString());
    }

    public static interface Listener {
        public void selectedInterpreterChanged();
    }
}

