/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TestUnitProgressBar
extends Canvas {
    private static final int DEFAULT_WIDTH = 160;
    private static final int DEFAULT_HEIGHT = 18;
    private int fCurrentTickCount = 0;
    private int fMaxTickCount = 0;
    private int fColorBarWidth = 0;
    private Color fOKColor;
    private Color fFailureColor;
    private Color fStoppedColor;
    private boolean fError;
    private boolean fStopped = false;

    public TestUnitProgressBar(Composite composite) {
        super(composite, 0);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                TestUnitProgressBar.this.fColorBarWidth = TestUnitProgressBar.this.scale(TestUnitProgressBar.this.fCurrentTickCount);
                TestUnitProgressBar.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TestUnitProgressBar.this.paint(paintEvent);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TestUnitProgressBar.this.fFailureColor.dispose();
                TestUnitProgressBar.this.fOKColor.dispose();
                TestUnitProgressBar.this.fStoppedColor.dispose();
            }
        });
        Display display = composite.getDisplay();
        this.fFailureColor = new Color((Device)display, 159, 63, 63);
        this.fOKColor = new Color((Device)display, 95, 191, 95);
        this.fStoppedColor = new Color((Device)display, 120, 120, 120);
    }

    public void setMaximum(int n) {
        this.fMaxTickCount = n;
    }

    public void reset() {
        this.fError = false;
        this.fStopped = false;
        this.fCurrentTickCount = 0;
        this.fColorBarWidth = 0;
        this.fMaxTickCount = 0;
        this.redraw();
    }

    private void paintStep(int n, int n2) {
        GC gC = new GC((Drawable)this);
        this.setStatusColor(gC);
        Rectangle rectangle = this.getClientArea();
        n = Math.max(1, n);
        gC.fillRectangle(n, 1, n2 - n, rectangle.height - 2);
        gC.dispose();
    }

    private void setStatusColor(GC gC) {
        if (this.fStopped) {
            gC.setBackground(this.fStoppedColor);
        } else if (this.fError) {
            gC.setBackground(this.fFailureColor);
        } else if (this.fStopped) {
            gC.setBackground(this.fStoppedColor);
        } else {
            gC.setBackground(this.fOKColor);
        }
    }

    public void stopped() {
        this.fStopped = true;
        this.redraw();
    }

    private int scale(int n) {
        if (this.fMaxTickCount > 0) {
            Rectangle rectangle = this.getClientArea();
            if (rectangle.width != 0) {
                return Math.max(0, n * (rectangle.width - 2) / this.fMaxTickCount);
            }
        }
        return n;
    }

    private void drawBevelRect(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        gC.setForeground(color);
        gC.drawLine(n, n2, n + n3 - 1, n2);
        gC.drawLine(n, n2, n, n2 + n4 - 1);
        gC.setForeground(color2);
        gC.drawLine(n + n3, n2, n + n3, n2 + n4);
        gC.drawLine(n, n2 + n4, n + n3, n2 + n4);
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        gC.fillRectangle(rectangle);
        this.drawBevelRect(gC, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, display.getSystemColor(18), display.getSystemColor(20));
        this.setStatusColor(gC);
        this.fColorBarWidth = Math.min(rectangle.width - 2, this.fColorBarWidth);
        gC.fillRectangle(1, 1, this.fColorBarWidth, rectangle.height - 2);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = new Point(160, 18);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    public void step(int n) {
        ++this.fCurrentTickCount;
        int n2 = this.fColorBarWidth;
        this.fColorBarWidth = this.scale(this.fCurrentTickCount);
        if (!this.fError && n > 0) {
            this.fError = true;
            n2 = 1;
        }
        if (this.fCurrentTickCount == this.fMaxTickCount) {
            this.fColorBarWidth = this.getClientArea().width - 1;
        }
        this.paintStep(n2, this.fColorBarWidth);
    }

    public void refresh(boolean bl) {
        this.fError = bl;
        this.redraw();
    }
}

