/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.BecomeWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.CommitWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.DiscardWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.ImportContainer;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.ReconcileWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyImport;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScriptElementInfo;
import org.rubypeople.rdt.internal.core.RubyScriptProblemFinder;
import org.rubypeople.rdt.internal.core.RubyScriptStructureBuilder;
import org.rubypeople.rdt.internal.core.RubyType;
import org.rubypeople.rdt.internal.core.buffer.BufferManager;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyScript
extends Openable
implements IRubyScript {
    private IFile underlyingFile;
    public WorkingCopyOwner owner;
    protected String name;

    public RubyScript(RubyElement rubyElement, IFile iFile, String string, WorkingCopyOwner workingCopyOwner) {
        super(rubyElement);
        this.name = string;
        this.owner = workingCopyOwner;
        this.underlyingFile = iFile;
    }

    protected Object createElementInfo() {
        return new RubyScriptElementInfo();
    }

    protected boolean buildStructure(OpenableElementInfo openableElementInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws RubyModelException {
        Object object;
        if (!this.isWorkingCopy() && !(object = this.validateRubyScript(iResource)).isOK()) {
            throw this.newRubyModelException((IStatus)object);
        }
        if (!this.isPrimary() && this.getPerWorkingCopyInfo() == null) {
            throw this.newNotPresentException();
        }
        object = (RubyScriptElementInfo)openableElementInfo;
        IBuffer iBuffer = this.getBufferManager().getBuffer(this);
        if (iBuffer == null) {
            iBuffer = this.openBuffer(iProgressMonitor, object);
        }
        char[] cArray = iBuffer == null ? null : iBuffer.getCharacters();
        RubyModelManager.PerWorkingCopyInfo perWorkingCopyInfo = this.getPerWorkingCopyInfo();
        IRubyProject iRubyProject = this.getRubyProject();
        boolean bl = RubyProject.hasRubyNature(iRubyProject.getProject()) && perWorkingCopyInfo != null && perWorkingCopyInfo.isActive();
        try {
            RubyParser rubyParser = new RubyParser();
            Node node = rubyParser.parse(this.underlyingFile, new CharArrayReader(cArray));
            RubyScriptStructureBuilder rubyScriptStructureBuilder = new RubyScriptStructureBuilder(this, (RubyScriptElementInfo)object, map);
            if (node != null) {
                node.accept((NodeVisitor)rubyScriptStructureBuilder);
            }
            ((RubyElementInfo)object).setIsStructureKnown(true);
        }
        catch (SyntaxException syntaxException) {
            ((RubyElementInfo)object).setIsStructureKnown(false);
            ((RubyScriptElementInfo)object).setSyntaxException(syntaxException);
        }
        catch (Exception exception) {
            RubyCore.log(exception);
        }
        if (iResource == null) {
            iResource = this.getResource();
        }
        ((RubyScriptElementInfo)object).timestamp = ((IFile)iResource).getModificationStamp();
        if (bl) {
            perWorkingCopyInfo.beginReporting();
            RubyScriptProblemFinder.process(this, cArray, perWorkingCopyInfo, iProgressMonitor);
            perWorkingCopyInfo.endReporting();
        }
        return ((RubyElementInfo)object).isStructureKnown();
    }

    protected void updateTimeStamp(RubyScript rubyScript) throws RubyModelException {
        long l = ((IFile)rubyScript.getResource()).getModificationStamp();
        if (l == -1L) {
            throw new RubyModelException(new RubyModelStatus(995));
        }
        ((RubyScriptElementInfo)this.getElementInfo()).timestamp = l;
    }

    protected IStatus validateRubyScript(IResource iResource) {
        return RubyModelStatus.VERIFIED_OK;
    }

    public IRubyElement getElementAt(int n) throws RubyModelException {
        IRubyElement iRubyElement = this.getSourceElementAt(n);
        if (iRubyElement == this) {
            return null;
        }
        return iRubyElement;
    }

    public String getElementName() {
        return this.name;
    }

    public IResource getUnderlyingResource() {
        if (this.isWorkingCopy() && !this.isPrimary()) {
            return null;
        }
        return this.underlyingFile;
    }

    public IResource getResource() {
        return this.underlyingFile;
    }

    public void close() throws RubyModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return;
        }
        super.close();
    }

    protected void closing(Object object) {
        if (this.getPerWorkingCopyInfo() == null) {
            super.closing(object);
        }
    }

    public WorkingCopyOwner getOwner() {
        return this.isPrimary() || !this.isWorkingCopy() ? null : this.owner;
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IRubyScript getPrimary() {
        return (IRubyScript)this.getPrimaryElement(true);
    }

    public IRubyElement getPrimaryElement(boolean bl) {
        if (bl && this.isPrimary()) {
            return this;
        }
        return new RubyScript((RubyElement)this.getParent(), this.underlyingFile, this.getElementName(), DefaultWorkingCopyOwner.PRIMARY);
    }

    public int getElementType() {
        return 2;
    }

    public void reconcile() throws RubyModelException {
        this.reconcile(false, null, null);
    }

    public void reconcile(boolean bl, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws RubyModelException {
        if (!this.isWorkingCopy()) {
            return;
        }
        if (workingCopyOwner == null) {
            workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        }
        ReconcileWorkingCopyOperation reconcileWorkingCopyOperation = new ReconcileWorkingCopyOperation(this, bl, workingCopyOwner);
        reconcileWorkingCopyOperation.runOperation(iProgressMonitor);
    }

    public IRubyScript getRubyScript() {
        return this;
    }

    public char[] getContents() {
        try {
            IBuffer iBuffer = this.getBuffer();
            return iBuffer == null ? null : iBuffer.getCharacters();
        }
        catch (RubyModelException rubyModelException) {
            return new char[0];
        }
    }

    public ISourceRange getSourceRange() throws RubyModelException {
        return ((RubyScriptElementInfo)this.getElementInfo()).getSourceRange();
    }

    public IType getType(String string) {
        return new RubyType(this, string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSource() {
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                bufferedReader = new BufferedReader(new InputStreamReader(this.underlyingFile.getContents()));
                String string2 = null;
                while (true) {
                    if ((string2 = bufferedReader.readLine()) == null) {
                        string = stringBuffer.toString();
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append("\n");
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        try {}
        catch (IOException iOException) {
            iOException.printStackTrace();
            return string;
        }
        if (bufferedReader == null) return string;
        bufferedReader.close();
        return string;
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor, Object object) throws RubyModelException {
        Object object2;
        IBuffer iBuffer;
        boolean bl = this.isWorkingCopy();
        IBuffer iBuffer2 = iBuffer = bl ? this.owner.createBuffer(this) : BufferManager.getDefaultBufferManager().createBuffer(this);
        if (iBuffer == null) {
            return null;
        }
        if (iBuffer.getCharacters() == null) {
            if (bl) {
                if (!this.isPrimary() && (object2 = new RubyScript((RubyElement)this.getParent(), this.underlyingFile, this.getElementName(), DefaultWorkingCopyOwner.PRIMARY)).isOpen()) {
                    iBuffer.setContents(object2.getSource());
                } else {
                    IFile iFile = (IFile)this.getResource();
                    if (iFile == null || !iFile.exists()) {
                        iBuffer.setContents(new char[0]);
                    } else {
                        iBuffer.setContents(Util.getResourceContentsAsCharArray(iFile));
                    }
                }
            } else {
                object2 = (IFile)this.getResource();
                if (object2 == null || !object2.exists()) {
                    throw this.newNotPresentException();
                }
                iBuffer.setContents(Util.getResourceContentsAsCharArray((IFile)object2));
            }
        }
        object2 = this.getBufferManager();
        ((BufferManager)object2).addBuffer(iBuffer);
        iBuffer.addBufferChangedListener(this);
        return iBuffer;
    }

    public boolean isPrimary() {
        return this.owner == DefaultWorkingCopyOwner.PRIMARY;
    }

    public boolean isWorkingCopy() {
        return !this.isPrimary() || this.getPerWorkingCopyInfo() != null;
    }

    public RubyModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return RubyModelManager.getRubyModelManager().getPerWorkingCopyInfo(this, false, false, null);
    }

    public IRubyScript getWorkingCopy(IProgressMonitor iProgressMonitor) throws RubyModelException {
        return this.getWorkingCopy(new WorkingCopyOwner(){}, null, iProgressMonitor);
    }

    public IRubyScript getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor iProblemRequestor, IProgressMonitor iProgressMonitor) throws RubyModelException {
        RubyScript rubyScript;
        if (!this.isPrimary()) {
            return this;
        }
        RubyModelManager rubyModelManager = RubyModelManager.getRubyModelManager();
        RubyModelManager.PerWorkingCopyInfo perWorkingCopyInfo = rubyModelManager.getPerWorkingCopyInfo(rubyScript = new RubyScript((RubyElement)this.getParent(), this.underlyingFile, this.getElementName(), DefaultWorkingCopyOwner.PRIMARY), false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation becomeWorkingCopyOperation = new BecomeWorkingCopyOperation(rubyScript, iProblemRequestor);
        becomeWorkingCopyOperation.runOperation(iProgressMonitor);
        return rubyScript;
    }

    public void becomeWorkingCopy(IProblemRequestor iProblemRequestor, IProgressMonitor iProgressMonitor) throws RubyModelException {
        RubyModelManager rubyModelManager = RubyModelManager.getRubyModelManager();
        RubyModelManager.PerWorkingCopyInfo perWorkingCopyInfo = rubyModelManager.getPerWorkingCopyInfo(this, false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation becomeWorkingCopyOperation = new BecomeWorkingCopyOperation(this, iProblemRequestor);
            becomeWorkingCopyOperation.runOperation(iProgressMonitor);
        }
    }

    public void commitWorkingCopy(boolean bl, IProgressMonitor iProgressMonitor) throws RubyModelException {
        CommitWorkingCopyOperation commitWorkingCopyOperation = new CommitWorkingCopyOperation(this, bl);
        commitWorkingCopyOperation.runOperation(iProgressMonitor);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RubyScript)) {
            return false;
        }
        RubyScript rubyScript = (RubyScript)object;
        return this.owner.equals(rubyScript.owner) && super.equals(object);
    }

    public int hashCode() {
        return this.underlyingFile.hashCode();
    }

    public boolean exists() {
        if (this.getPerWorkingCopyInfo() != null) {
            return true;
        }
        return this.isPrimary();
    }

    public boolean canBeRemovedFromCache() {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBeRemovedFromCache();
    }

    public boolean canBufferBeRemovedFromCache(IBuffer iBuffer) {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBufferBeRemovedFromCache(iBuffer);
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object object = RubyModelManager.getRubyModelManager().getInfo(this);
        if (object == null) {
            return false;
        }
        return ((RubyScriptElementInfo)object).timestamp != this.getResource().getModificationStamp();
    }

    public boolean isConsistent() {
        return RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    public void makeConsistent(IProgressMonitor iProgressMonitor) throws RubyModelException {
        this.makeConsistent(false, iProgressMonitor);
    }

    public RubyScript makeConsistent(boolean bl, IProgressMonitor iProgressMonitor) throws RubyModelException {
        if (this.isConsistent()) {
            return null;
        }
        this.openWhenClosed(this.createElementInfo(), iProgressMonitor);
        return null;
    }

    public void discardWorkingCopy() throws RubyModelException {
        DiscardWorkingCopyOperation discardWorkingCopyOperation = new DiscardWorkingCopyOperation(this);
        discardWorkingCopyOperation.runOperation(null);
    }

    public void save(IProgressMonitor iProgressMonitor, boolean bl) throws RubyModelException {
        if (this.isWorkingCopy()) {
            this.reconcile();
        } else {
            super.save(iProgressMonitor, bl);
        }
    }

    public IImportDeclaration[] getImports() throws RubyModelException {
        IImportContainer iImportContainer = this.getImportContainer();
        if (iImportContainer.exists()) {
            IRubyElement[] iRubyElementArray = iImportContainer.getChildren();
            IImportDeclaration[] iImportDeclarationArray = new IImportDeclaration[iRubyElementArray.length];
            System.arraycopy(iRubyElementArray, 0, iImportDeclarationArray, 0, iRubyElementArray.length);
            return iImportDeclarationArray;
        }
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return new IImportDeclaration[0];
    }

    public IImportDeclaration getImport(String string) {
        return new RubyImport((ImportContainer)this.getImportContainer(), string);
    }

    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    public IType[] getTypes() throws RubyModelException {
        ArrayList arrayList = this.getChildrenOfType(3);
        IType[] iTypeArray = new IType[arrayList.size()];
        arrayList.toArray(iTypeArray);
        return iTypeArray;
    }

    public IType findPrimaryType() {
        String string = Util.getNameWithoutRubyLikeExtension(this.getElementName());
        IType iType = this.getType(string);
        if (iType.exists()) {
            return iType;
        }
        return null;
    }

    public IRubyElement[] codeSelect(int n, int n2) throws RubyModelException {
        return this.codeSelect(n, n2, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IRubyElement[] codeSelect(int n, int n2, WorkingCopyOwner workingCopyOwner) throws RubyModelException {
        return super.codeSelect(this, n, n2, workingCopyOwner);
    }
}

