/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNCompareEditorInput;

public class CompareRemoteResourcesAction
extends SVNAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ISVNRemoteResource[] editions = CompareRemoteResourcesAction.this.getSelectedRemoteResources();
                if (editions == null || editions.length != 2) {
                    MessageDialog.openError((Shell)CompareRemoteResourcesAction.this.getShell(), (String)Policy.bind("CompareRemoteResourcesAction.unableToCompare"), (String)Policy.bind("CompareRemoteResourcesAction.selectTwoResources"));
                    return;
                }
                ResourceEditionNode left = new ResourceEditionNode(editions[0]);
                ResourceEditionNode right = new ResourceEditionNode(editions[1]);
                CompareUI.openCompareEditorOnPage((CompareEditorInput)new SVNCompareEditorInput(left, right), (IWorkbenchPage)CompareRemoteResourcesAction.this.getTargetPage());
            }
        }, false, 2);
    }

    protected boolean isEnabled() {
        ISVNRemoteResource[] resources = this.getSelectedRemoteResources();
        if (resources.length != 2) {
            return false;
        }
        return resources[0].isContainer() == resources[1].isContainer();
    }

    protected String getImageId() {
        return "Menu Compare";
    }
}

