/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private ICompilationUnitDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(ICompilationUnitDocumentProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fDocumentProvider = provider;
    }

    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    public void shutdown() {
        if (!this.fIsShuttingDown) {
            this.fIsShuttingDown = true;
            try {
                if (this.fMap != null) {
                    this.fMap.clear();
                    this.fMap = null;
                }
                this.fDocumentProvider.shutdown();
            }
            finally {
                this.fIsShuttingDown = false;
            }
        }
    }

    public ICompilationUnit getWorkingCopy(IEditorInput input) {
        return this.getWorkingCopy(input, true);
    }

    public ICompilationUnit getWorkingCopy(IEditorInput input, boolean primaryOnly) {
        ICompilationUnit unit;
        ICompilationUnit iCompilationUnit = unit = this.fMap == null ? null : (ICompilationUnit)this.fMap.get(input);
        if (unit == null) {
            unit = this.fDocumentProvider.getWorkingCopy(input);
        }
        if (unit != null && (!primaryOnly || JavaModelUtil.isPrimary(unit))) {
            return unit;
        }
        return null;
    }

    public void setWorkingCopy(IEditorInput input, ICompilationUnit workingCopy) {
        if (this.fDocumentProvider.getDocument(input) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

