/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.model.ITestRunSessionListener;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public final class JUnitModel {
    private final ListenerList fTestRunSessionListeners = new ListenerList();
    private final LinkedList fTestRunSessions = new LinkedList();
    private final ILaunchListener fLaunchListener = new JUnitLaunchListener();

    public void start() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener(this.fLaunchListener);
        this.addTestRunSessionListener(new LegacyTestRunSessionListener());
    }

    public void stop() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener(this.fLaunchListener);
    }

    public void addTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.add((Object)listener);
    }

    public void removeTestRunSessionListener(ITestRunSessionListener listener) {
        this.fTestRunSessionListeners.remove((Object)listener);
    }

    public List getTestRunSessions() {
        return new ArrayList(this.fTestRunSessions);
    }

    public void removeTestRunSession(TestRunSession testRunSession) {
        boolean existed = this.fTestRunSessions.remove(testRunSession);
        if (existed) {
            this.notifyTestRunSessionRemoved(testRunSession);
        }
    }

    private void notifyTestRunSessionRemoved(TestRunSession testRunSession) {
        testRunSession.stopTestRun();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunch(testRunSession.getLaunch());
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionRemoved(testRunSession);
            ++i;
        }
    }

    private void notifyTestRunSessionAdded(TestRunSession testRunSession) {
        Object[] listeners = this.fTestRunSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ITestRunSessionListener)listeners[i]).sessionAdded(testRunSession);
            ++i;
        }
    }

    private final class JUnitLaunchListener
    implements ILaunchListener {
        private HashSet fTrackedLaunches = new HashSet(20);

        private JUnitLaunchListener() {
        }

        public void launchAdded(ILaunch launch) {
            this.fTrackedLaunches.add(launch);
        }

        public void launchRemoved(ILaunch launch) {
            this.fTrackedLaunches.remove(launch);
        }

        public void launchChanged(final ILaunch launch) {
            if (!this.fTrackedLaunches.contains(launch)) {
                return;
            }
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            if (config == null) {
                return;
            }
            String portStr = launch.getAttribute("org.eclipse.jdt.junit.PORT");
            String typeStr = launch.getAttribute("org.eclipse.jdt.junit.TESTTYPE");
            if (portStr == null || typeStr == null) {
                return;
            }
            IJavaElement element = JavaCore.create((String)typeStr);
            if (!(element instanceof IType)) {
                return;
            }
            final int port = Integer.parseInt(portStr);
            final IType launchedType = (IType)element;
            this.fTrackedLaunches.remove(launch);
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JUnitLaunchListener.this.connectTestRunner(launch, launchedType, port);
                }
            });
        }

        private void connectTestRunner(ILaunch launch, IType launchedType, int port) {
            this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
            int maxCount = JUnitPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.jdt.junit.max_test_runs");
            int toDelete = JUnitModel.this.fTestRunSessions.size() - maxCount;
            while (toDelete > 0) {
                --toDelete;
                TestRunSession session = (TestRunSession)JUnitModel.this.fTestRunSessions.removeLast();
                JUnitModel.this.notifyTestRunSessionRemoved(session);
            }
            TestRunSession testRunSession = new TestRunSession(launchedType, port, launch);
            JUnitModel.this.fTestRunSessions.addFirst(testRunSession);
            JUnitModel.this.notifyTestRunSessionAdded(testRunSession);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
            block12: {
                block11: {
                    block9: {
                        block10: {
                            activePart = null;
                            page = null;
                            try {
                                if (testRunner != null && testRunner.isCreated()) {
                                    var6_4 = testRunner;
                                    if (page == null || activePart == null) break block9;
                                    break block10;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (PartInitException pie) {
                                JUnitPlugin.log(pie);
                            }
                            finally {
                                if (page == null || activePart == null) break block11;
                            }
                        }
                        page.activate(activePart);
                    }
                    return var6_4;
lbl-1000:
                    // 1 sources

                    {
                        page = JUnitPlugin.getActivePage();
                        if (page == null) {
                        }
                        ** GOTO lbl-1000
                    }
                    page.activate(activePart);
                }
                return null;
lbl-1000:
                // 1 sources

                {
                    activePart = page.getActivePart();
                    var6_5 = (TestRunnerViewPart)page.showView("org.eclipse.jdt.junit.ResultView");
                    if (page == null || activePart == null) break block12;
                }
                page.activate(activePart);
            }
            return var6_5;
        }

        private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
            IWorkbenchPage page = JUnitPlugin.getActivePage();
            if (page == null) {
                return null;
            }
            return (TestRunnerViewPart)page.findView("org.eclipse.jdt.junit.ResultView");
        }

        private Display getDisplay() {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            return display;
        }
    }

    private static final class LegacyTestRunSessionListener
    implements ITestRunSessionListener {
        private TestRunSession fActiveTestRunSession;
        private ITestSessionListener fTestSessionListener;

        private LegacyTestRunSessionListener() {
        }

        public void sessionAdded(TestRunSession testRunSession) {
            if (this.fActiveTestRunSession != null) {
                return;
            }
            this.fActiveTestRunSession = testRunSession;
            this.fTestSessionListener = new ITestSessionListener(){

                public void testAdded(TestElement testElement) {
                }

                public void sessionStarted() {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testRunStarted(LegacyTestRunSessionListener.this.fActiveTestRunSession.getTotalCount());
                        ++i;
                    }
                }

                public void sessionTerminated() {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testRunTerminated();
                        ++i;
                    }
                    LegacyTestRunSessionListener.this.sessionRemoved(LegacyTestRunSessionListener.this.fActiveTestRunSession);
                }

                public void sessionStopped(long elapsedTime) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testRunStopped(elapsedTime);
                        ++i;
                    }
                    LegacyTestRunSessionListener.this.sessionRemoved(LegacyTestRunSessionListener.this.fActiveTestRunSession);
                }

                public void sessionEnded(long elapsedTime) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testRunEnded(elapsedTime);
                        ++i;
                    }
                    LegacyTestRunSessionListener.this.sessionRemoved(LegacyTestRunSessionListener.this.fActiveTestRunSession);
                }

                public void testStarted(TestCaseElement testCaseElement) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testStarted(testCaseElement.getId(), testCaseElement.getTestName());
                        ++i;
                    }
                }

                public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testFailed(status.getOldCode(), testElement.getId(), testElement.getTestName(), trace);
                        ++i;
                    }
                }

                public void testEnded(TestCaseElement testCaseElement) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testEnded(testCaseElement.getId(), testCaseElement.getTestName());
                        ++i;
                    }
                }

                public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
                    ITestRunListener[] testRunListeners = JUnitPlugin.getDefault().getTestRunListeners();
                    int i = 0;
                    while (i < testRunListeners.length) {
                        ITestRunListener testRunListener = testRunListeners[i];
                        testRunListener.testReran(testCaseElement.getId(), testCaseElement.getClassName(), testCaseElement.getTestMethodName(), status.getOldCode(), trace);
                        ++i;
                    }
                }
            };
            this.fActiveTestRunSession.addTestSessionListener(this.fTestSessionListener);
        }

        public void sessionRemoved(TestRunSession testRunSession) {
            if (this.fActiveTestRunSession == testRunSession) {
                this.fActiveTestRunSession.removeTestSessionListener(this.fTestSessionListener);
                this.fTestSessionListener = null;
                this.fActiveTestRunSession = null;
            }
        }
    }
}

