/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;

public class JavaBeanObservableValue
extends AbstractObservableValue {
    private final Object object;
    private PropertyChangeListener listener;
    private boolean updating = false;
    private final PropertyDescriptor propertyDescriptor;

    public JavaBeanObservableValue(Object object, PropertyDescriptor descriptor) {
        this.object = object;
        this.propertyDescriptor = descriptor;
    }

    protected void firstListenerAdded() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!JavaBeanObservableValue.this.updating && event.getPropertyName().equals(JavaBeanObservableValue.this.propertyDescriptor.getName())) {
                    JavaBeanObservableValue.this.fireValueChange(Diffs.createValueDiff(event.getOldValue(), event.getNewValue()));
                }
            }
        };
        Method addPropertyChangeListenerMethod = null;
        try {
            addPropertyChangeListenerMethod = this.object.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (addPropertyChangeListenerMethod != null) {
            try {
                addPropertyChangeListenerMethod.invoke(this.object, this.propertyDescriptor.getName(), this.listener);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.listener = null;
    }

    public void setValue(Object value) {
        this.updating = true;
        try {
            try {
                Object oldValue = this.doGetValue();
                Method writeMethod = this.propertyDescriptor.getWriteMethod();
                if (!writeMethod.isAccessible()) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(this.object, value);
                this.fireValueChange(Diffs.createValueDiff(oldValue, this.doGetValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.updating = false;
        }
    }

    public Object doGetValue() {
        try {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                throw new BindingException(String.valueOf(this.propertyDescriptor.getName()) + " property does not have a read method.");
            }
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void lastListenerRemoved() {
        if (this.listener != null) {
            Method removePropertyChangeListenerMethod = null;
            try {
                removePropertyChangeListenerMethod = this.object.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (removePropertyChangeListenerMethod != null) {
                try {
                    removePropertyChangeListenerMethod.invoke(this.object, this.propertyDescriptor.getName(), this.listener);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            this.listener = null;
        }
    }

    public Object getValueType() {
        return this.propertyDescriptor.getPropertyType();
    }
}

