/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.mapping;

import java.util.Iterator;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservableCollection;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.AbstractObservableMultiMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMultiMappingWithDomain;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;

public abstract class ObservableMultiMappingWithDomain
extends AbstractObservableMultiMapping
implements IObservableMultiMappingWithDomain {
    private ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(IObservableSet source, SetDiff diff) {
            Iterator it = diff.getAdditions().iterator();
            while (it.hasNext()) {
                ObservableMultiMappingWithDomain.this.addListenerTo(it.next());
            }
            it = diff.getRemovals().iterator();
            while (it.hasNext()) {
                ObservableMultiMappingWithDomain.this.removeListenerFrom(it.next());
            }
        }
    };
    private IListChangeListener listListener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
            ListDiffEntry[] entries = diff.getDifferences();
            int i = 0;
            while (i < entries.length) {
                ListDiffEntry entry = entries[i];
                if (entry.isAddition()) {
                    ObservableMultiMappingWithDomain.this.addListenerTo(entry.getElement());
                } else {
                    ObservableMultiMappingWithDomain.this.removeListenerFrom(entry.getElement());
                }
                ++i;
            }
        }
    };
    private IObservableCollection domain;

    protected void initDomain(IObservableCollection domain) {
        this.domain = domain;
        if (domain instanceof IObservableList) {
            IObservableList listDomain = (IObservableList)domain;
            listDomain.addListChangeListener(this.listListener);
        } else {
            ((IObservableSet)domain).addSetChangeListener(this.listener);
        }
        Iterator it = this.getDomainIterator(domain);
        while (it.hasNext()) {
            this.addListenerTo(it.next());
        }
    }

    private Iterator getDomainIterator(IObservableCollection domain) {
        Iterator it;
        if (domain instanceof IObservableList) {
            IObservableList listDomain = (IObservableList)domain;
            it = listDomain.iterator();
        } else {
            IObservableSet setDomain = (IObservableSet)domain;
            it = setDomain.iterator();
        }
        return it;
    }

    public IObservableCollection getDomain() {
        return this.domain;
    }

    protected abstract void addListenerTo(Object var1);

    protected abstract void removeListenerFrom(Object var1);

    public void dispose() {
        Iterator iter = this.getDomainIterator(this.domain);
        while (iter.hasNext()) {
            this.removeListenerFrom(iter.next());
        }
        if (this.domain instanceof IObservableList) {
            IObservableList listDomain = (IObservableList)this.domain;
            listDomain.removeListChangeListener(this.listListener);
        } else {
            IObservableSet setDomain = (IObservableSet)this.domain;
            setDomain.removeSetChangeListener(this.listener);
        }
        super.dispose();
    }
}

