/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.Collection;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.menus.IMenuContribution;
import org.eclipse.ui.internal.menus.IMenuService;
import org.eclipse.ui.internal.menus.MenuAuthority;
import org.eclipse.ui.internal.menus.MenuContribution;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.MenuPersistence;
import org.eclipse.ui.internal.menus.SActionSet;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SItem;
import org.eclipse.ui.internal.menus.SMenu;
import org.eclipse.ui.internal.menus.SMenuLayout;
import org.eclipse.ui.internal.menus.SMenuManager;
import org.eclipse.ui.internal.menus.SWidget;

public final class WorkbenchMenuService
implements IMenuService {
    private final MenuAuthority menuAuthority = new MenuAuthority(null);
    private final SMenuManager menuManager;
    private final MenuPersistence menuPersistence;

    public WorkbenchMenuService(SMenuManager menuManager, ICommandService commandService) {
        this.menuManager = menuManager;
        this.menuPersistence = new MenuPersistence(this, commandService);
    }

    public final void addSourceProvider(ISourceProvider provider) {
        this.menuAuthority.addSourceProvider(provider);
    }

    public final IMenuContribution contributeMenu(MenuElement menuElement) {
        return this.contributeMenu(menuElement, null);
    }

    public final IMenuContribution contributeMenu(MenuElement menuElement, Expression expression) {
        MenuContribution contribution = new MenuContribution(menuElement, expression, this);
        this.menuAuthority.contributeMenu(contribution);
        return contribution;
    }

    public final void dispose() {
        this.menuPersistence.dispose();
        this.menuAuthority.dispose();
    }

    public final SActionSet getActionSet(String actionSetId) {
        return this.menuManager.getActionSet(actionSetId);
    }

    public final SActionSet[] getDefinedActionSets() {
        return this.menuManager.getDefinedActionSets();
    }

    public final SGroup[] getDefinedGroups() {
        return this.menuManager.getDefinedGroups();
    }

    public final SItem[] getDefinedItems() {
        return this.menuManager.getDefinedItems();
    }

    public final SMenu[] getDefinedMenus() {
        return this.menuManager.getDefinedMenus();
    }

    public final SWidget[] getDefinedWidgets() {
        return this.menuManager.getDefinedWidgets();
    }

    public final SGroup getGroup(String groupId) {
        return this.menuManager.getGroup(groupId);
    }

    public final SItem getItem(String itemId) {
        return this.menuManager.getItem(itemId);
    }

    public final SMenuLayout getLayout() {
        return this.menuManager.getLayout();
    }

    public final SMenu getMenu(String menuId) {
        return this.menuManager.getMenu(menuId);
    }

    public final SWidget getWidget(String widgetId) {
        return this.menuManager.getWidget(widgetId);
    }

    public final void readRegistry() {
        this.menuPersistence.read();
    }

    public final void removeContribution(IMenuContribution contribution) {
        if (contribution.getMenuService() == this) {
            this.menuAuthority.removeContribution(contribution);
        }
    }

    public final void removeContributions(Collection contributions) {
        for (IMenuContribution contribution : contributions) {
            this.removeContribution(contribution);
        }
    }

    public final void removeSourceProvider(ISourceProvider provider) {
        this.menuAuthority.removeSourceProvider(provider);
    }
}

