/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPageSource;
import org.eclipse.team.internal.ccvs.ui.CVSTeamStateProvider;
import org.eclipse.team.internal.ccvs.ui.mappings.ChangeSetCompareAdapter;
import org.eclipse.team.internal.ccvs.ui.model.CVSRemoteFilePropertySource;
import org.eclipse.team.internal.ccvs.ui.model.CVSRemoteFolderPropertySource;
import org.eclipse.team.internal.ccvs.ui.model.CVSRepositoryLocationPropertySource;
import org.eclipse.team.internal.ccvs.ui.model.CVSRepositoryRootElement;
import org.eclipse.team.internal.ccvs.ui.model.RemoteFileElement;
import org.eclipse.team.internal.ccvs.ui.model.RemoteFolderElement;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.mapping.ITeamStateProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;

public class CVSAdapterFactory
implements IAdapterFactory {
    private static Object fileAdapter = new RemoteFileElement();
    private static Object folderAdapter = new RemoteFolderElement();
    private static Object rootAdapter = new CVSRepositoryRootElement();
    private static Object historyParticipant = new CVSHistoryPageSource();
    private static Object teamStateProvider;
    private Object cachedPropertyObject = null;
    private Object cachedPropertyValue = null;
    private ChangeSetCompareAdapter compareAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (IWorkbenchAdapter.class == adapterType) {
            return this.getWorkbenchAdapter(adaptableObject);
        }
        if (IDeferredWorkbenchAdapter.class == adapterType) {
            Object o = this.getWorkbenchAdapter(adaptableObject);
            if (o != null && o instanceof IDeferredWorkbenchAdapter) {
                return o;
            }
            return null;
        }
        if (IPropertySource.class == adapterType) {
            return this.getPropertySource(adaptableObject);
        }
        if (IHistoryPageSource.class == adapterType) {
            return historyParticipant;
        }
        if (ITeamStateProvider.class == adapterType) {
            CVSAdapterFactory cVSAdapterFactory = this;
            synchronized (cVSAdapterFactory) {
                if (teamStateProvider == null) {
                    teamStateProvider = new CVSTeamStateProvider((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
                }
            }
            return teamStateProvider;
        }
        if (ISynchronizationCompareAdapter.class == adapterType) {
            if (this.compareAdapter == null) {
                this.compareAdapter = new ChangeSetCompareAdapter();
            }
            return this.compareAdapter;
        }
        return null;
    }

    protected Object getWorkbenchAdapter(Object o) {
        if (o instanceof ICVSRemoteFile) {
            return fileAdapter;
        }
        if (o instanceof ICVSRepositoryLocation) {
            return rootAdapter;
        }
        if (o instanceof RepositoryRoot) {
            return rootAdapter;
        }
        if (o instanceof ICVSRemoteFolder) {
            return folderAdapter;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IWorkbenchAdapter.class, IPropertySource.class, IDeferredWorkbenchAdapter.class, IHistoryPageSource.class, ISynchronizationCompareAdapter.class, ITeamStateProvider.class};
    }

    public Object getPropertySource(Object adaptableObject) {
        if (adaptableObject == this.cachedPropertyObject) {
            return this.cachedPropertyValue;
        }
        this.cachedPropertyObject = adaptableObject;
        this.cachedPropertyValue = adaptableObject instanceof ICVSRemoteFile ? new CVSRemoteFilePropertySource((ICVSRemoteFile)adaptableObject) : (adaptableObject instanceof ICVSRemoteFolder ? new CVSRemoteFolderPropertySource((ICVSRemoteFolder)adaptableObject) : (adaptableObject instanceof ICVSRepositoryLocation ? new CVSRepositoryLocationPropertySource((ICVSRepositoryLocation)adaptableObject) : (adaptableObject instanceof RepositoryRoot ? new CVSRepositoryLocationPropertySource(((RepositoryRoot)((Object)adaptableObject)).getRoot()) : null)));
        return this.cachedPropertyValue;
    }
}

