/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class NavigatorPipelineService
implements INavigatorPipelineService {
    private NavigatorContentService contentService;

    public NavigatorPipelineService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        ContributorTrackingSet trackedSet = (ContributorTrackingSet)anAddModification.getChildren();
        Set contentDescriptors = this.contentService.findDescriptorsByTriggerPoint(anAddModification.getParent());
        for (INavigatorContentDescriptor descriptor : contentDescriptors) {
            this.pipelineInterceptAdd(anAddModification, trackedSet, descriptor);
        }
        return anAddModification;
    }

    private void pipelineInterceptAdd(PipelinedShapeModification anAddModification, ContributorTrackingSet trackedSet, INavigatorContentDescriptor descriptor) {
        if (descriptor.hasOverridingExtensions()) {
            Set overridingDescriptors = descriptor.getOverriddingExtensions();
            for (INavigatorContentDescriptor overridingDescriptor : overridingDescriptors) {
                if (!this.contentService.isVisible(overridingDescriptor.getId()) || !this.contentService.isActive(overridingDescriptor.getId())) continue;
                trackedSet.setContributor((NavigatorContentDescriptor)overridingDescriptor);
                NavigatorContentExtension extension = this.contentService.getExtension(overridingDescriptor);
                ((IPipelinedTreeContentProvider)extension.internalGetContentProvider()).interceptAdd(anAddModification);
                trackedSet.setContributor(null);
                this.pipelineInterceptAdd(anAddModification, trackedSet, overridingDescriptor);
            }
        }
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        ContributorTrackingSet trackedSet = (ContributorTrackingSet)aRemoveModification.getChildren();
        Set interestedExtensions = new LinkedHashSet();
        for (Object element : trackedSet) {
            if (element instanceof TreePath) {
                interestedExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(((TreePath)element).getLastSegment()));
                continue;
            }
            interestedExtensions = this.contentService.findOverrideableContentExtensionsForPossibleChild(element);
        }
        Iterator overridingExtensionsIter = interestedExtensions.iterator();
        while (overridingExtensionsIter.hasNext()) {
            this.pipelineInterceptRemove(aRemoveModification, trackedSet, (NavigatorContentExtension)overridingExtensionsIter.next());
        }
        return aRemoveModification;
    }

    private void pipelineInterceptRemove(PipelinedShapeModification aRemoveModification, ContributorTrackingSet trackedSet, NavigatorContentExtension overrideableExtension) {
        try {
            NavigatorContentExtension overridingExtension2 = null;
            LinkedHashSet overridingExtensions = new LinkedHashSet();
            for (Object element : trackedSet) {
                if (element instanceof TreePath) {
                    overridingExtensions.addAll(Arrays.asList(overrideableExtension.getOverridingExtensionsForPossibleChild(((TreePath)element).getLastSegment())));
                    continue;
                }
                overridingExtensions.addAll(Arrays.asList(overrideableExtension.getOverridingExtensionsForPossibleChild(element)));
            }
            for (NavigatorContentExtension overridingExtension2 : overridingExtensions) {
                trackedSet.setContributor((NavigatorContentDescriptor)overridingExtension2.getDescriptor());
                if (overridingExtension2.getContentProvider() instanceof IPipelinedTreeContentProvider) {
                    ((IPipelinedTreeContentProvider)overridingExtension2.getContentProvider()).interceptRemove(aRemoveModification);
                }
                trackedSet.setContributor(null);
                if (!overridingExtension2.getDescriptor().hasOverridingExtensions()) continue;
                this.pipelineInterceptRemove(aRemoveModification, trackedSet, overridingExtension2);
            }
        }
        catch (Throwable e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            NavigatorPlugin.logError(0, msg, e);
        }
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        boolean pipelined = false;
        Object refreshable2 = null;
        LinkedHashSet overrideableExtensions = new LinkedHashSet();
        for (Object refreshable2 : aRefreshSynchronization.getRefreshTargets()) {
            overrideableExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(refreshable2));
        }
        Iterator overrideableExtensionItr = overrideableExtensions.iterator();
        while (overrideableExtensionItr.hasNext()) {
            pipelined |= this.pipelineInterceptRefresh((NavigatorContentExtension)overrideableExtensionItr.next(), aRefreshSynchronization, refreshable2);
        }
        return pipelined;
    }

    private boolean pipelineInterceptRefresh(NavigatorContentExtension overrideableExtension, PipelinedViewerUpdate aRefreshSynchronization, Object refreshable) {
        boolean intercepted = false;
        NavigatorContentExtension[] overridingExtensionsForPossibleChild = overrideableExtension.getOverridingExtensionsForPossibleChild(refreshable);
        int i = 0;
        while (i < overridingExtensionsForPossibleChild.length) {
            try {
                if (overridingExtensionsForPossibleChild[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                    intercepted |= ((IPipelinedTreeContentProvider)overridingExtensionsForPossibleChild[i].getContentProvider()).interceptRefresh(aRefreshSynchronization);
                    if (overridingExtensionsForPossibleChild[i].getDescriptor().hasOverridingExtensions()) {
                        intercepted |= this.pipelineInterceptRefresh(overridingExtensionsForPossibleChild[i], aRefreshSynchronization, refreshable);
                    }
                }
            }
            catch (Throwable e) {
                String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                NavigatorPlugin.logError(0, msg, e);
            }
            ++i;
        }
        return intercepted;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        boolean pipelined = false;
        Object refreshable2 = null;
        LinkedHashSet overrideableExtensions = new LinkedHashSet();
        for (Object refreshable2 : anUpdateSynchronization.getRefreshTargets()) {
            overrideableExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(refreshable2));
        }
        Iterator overrideableExtensionItr = overrideableExtensions.iterator();
        while (overrideableExtensionItr.hasNext()) {
            pipelined |= this.pipelineInterceptUpdate((NavigatorContentExtension)overrideableExtensionItr.next(), anUpdateSynchronization, refreshable2);
        }
        return pipelined;
    }

    private boolean pipelineInterceptUpdate(NavigatorContentExtension overrideableExtension, PipelinedViewerUpdate anUpdateSynchronization, Object refreshable) {
        boolean intercepted = false;
        NavigatorContentExtension[] overridingExtensionsForPossibleChild = overrideableExtension.getOverridingExtensionsForPossibleChild(refreshable);
        int i = 0;
        while (i < overridingExtensionsForPossibleChild.length) {
            try {
                if (overridingExtensionsForPossibleChild[i].getContentProvider() instanceof IPipelinedTreeContentProvider) {
                    intercepted |= ((IPipelinedTreeContentProvider)overridingExtensionsForPossibleChild[i].getContentProvider()).interceptUpdate(anUpdateSynchronization);
                    if (overridingExtensionsForPossibleChild[i].getDescriptor().hasOverridingExtensions()) {
                        intercepted |= this.pipelineInterceptUpdate(overridingExtensionsForPossibleChild[i], anUpdateSynchronization, refreshable);
                    }
                }
            }
            catch (Throwable e) {
                String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                NavigatorPlugin.logError(0, msg, e);
            }
            ++i;
        }
        return intercepted;
    }
}

