/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.ui.DebugPopup;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.DisplayAction;
import org.eclipse.jdt.internal.debug.ui.display.DisplayView;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class PopupDisplayAction
extends DisplayAction {
    public static final String ACTION_DEFINITION_ID = "org.eclipse.jdt.debug.ui.commands.Display";
    private ITextViewer viewer;
    private String snippet;
    private String resultString;

    private void showPopup() {
        DisplayPopup displayPopup = new DisplayPopup(this.getShell(), this.viewer);
        displayPopup.open();
    }

    protected void displayStringResult(String currentSnippet, String currentResultString) {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof DisplayView) {
            super.displayStringResult(currentSnippet, currentResultString);
            return;
        }
        this.viewer = (ITextViewer)part.getAdapter(ITextViewer.class);
        if (this.viewer == null && part instanceof JavaEditor) {
            this.viewer = ((JavaEditor)part).getViewer();
        }
        if (this.viewer == null) {
            super.displayStringResult(currentSnippet, currentResultString);
        } else {
            this.snippet = currentSnippet;
            this.resultString = currentResultString;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    PopupDisplayAction.this.showPopup();
                }
            });
            this.evaluationCleanup();
        }
    }

    private class DisplayPopup
    extends DebugPopup {
        public DisplayPopup(Shell shell, ITextViewer viewer) {
            super(shell, PopupDisplayAction.getPopupAnchor(viewer), PopupDisplayAction.ACTION_DEFINITION_ID);
        }

        protected String getActionText() {
            return ActionMessages.PopupDisplayAction_2;
        }

        protected void persist() {
            IDataDisplay dataDisplay;
            IDataDisplay directDisplay = PopupDisplayAction.this.getDirectDataDisplay();
            Display display = JDIDebugUIPlugin.getStandardDisplay();
            if (!display.isDisposed() && (dataDisplay = PopupDisplayAction.this.getDataDisplay()) != null) {
                if (directDisplay == null) {
                    dataDisplay.displayExpression(PopupDisplayAction.this.snippet);
                }
                dataDisplay.displayExpressionValue(PopupDisplayAction.this.resultString);
            }
        }

        protected Control createDialogArea(Composite parent) {
            GridData gd = new GridData(1808);
            StyledText text = new StyledText(parent, 842);
            text.setLayoutData((Object)gd);
            text.setForeground(parent.getDisplay().getSystemColor(28));
            text.setBackground(parent.getDisplay().getSystemColor(29));
            text.setText(PopupDisplayAction.this.resultString);
            return text;
        }
    }
}

