/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.help.internal.FilterableHelpElement;
import org.eclipse.help.internal.toc.ITocNode;
import org.eclipse.help.internal.toc.Topic;

abstract class TocNode
extends FilterableHelpElement
implements ITocNode {
    protected List children;
    protected List parents;

    TocNode() {
    }

    public void addChild(ITocNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        if (child instanceof TocNode) {
            ((TocNode)child).addParent(this);
        }
    }

    protected void addParent(ITocNode parent) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        this.parents.add(parent);
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    protected List getParents() {
        if (this.parents == null) {
            return Collections.EMPTY_LIST;
        }
        return this.parents;
    }

    public List getChildTopics() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TocNode> childTopics = new ArrayList<TocNode>(this.children.size());
        for (TocNode c : this.children) {
            if (c instanceof Topic) {
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(c.getChildTopics());
        }
        return childTopics;
    }
}

