/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RoundFunction
extends Expr {
    final Expr arg;

    RoundFunction(List<Expr> args) {
        this(args.get(0));
    }

    RoundFunction(Expr arg) {
        this.arg = arg;
    }

    @Override
    public Object evaluate(Node context, int pos, int len) {
        Object val = this.arg.evaluate(context, pos, len);
        double n = RoundFunction._number(context, val);
        return Double.isNaN(n) || Double.isInfinite(n) ? new Double(n) : new Double(Math.round(n));
    }

    @Override
    public Expr clone(Object context) {
        return new RoundFunction(this.arg.clone(context));
    }

    @Override
    public boolean references(QName var) {
        return this.arg.references(var);
    }

    public String toString() {
        return "round(" + this.arg + ")";
    }
}

