/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    private float[] scale;
    private float[] offsets;
    private RenderingHints hints = null;

    public RescaleOp(float[] scaleFactors, float[] offsets, RenderingHints hints) {
        int length = Math.min(scaleFactors.length, offsets.length);
        this.scale = new float[length];
        System.arraycopy(scaleFactors, 0, this.scale, 0, length);
        this.offsets = new float[length];
        System.arraycopy(offsets, 0, this.offsets, 0, length);
        this.hints = hints;
    }

    public RescaleOp(float scaleFactor, float offset, RenderingHints hints) {
        this.scale = new float[]{scaleFactor};
        this.offsets = new float[]{offset};
        this.hints = hints;
    }

    public final float[] getScaleFactors(float[] scaleFactors) {
        if (scaleFactors == null) {
            scaleFactors = new float[this.scale.length];
        }
        System.arraycopy(this.scale, 0, scaleFactors, 0, Math.min(this.scale.length, scaleFactors.length));
        return scaleFactors;
    }

    public final float[] getOffsets(float[] offsets) {
        if (offsets == null) {
            offsets = new float[this.offsets.length];
        }
        System.arraycopy(this.offsets, 0, offsets, 0, Math.min(this.offsets.length, offsets.length));
        return offsets;
    }

    public final int getNumFactors() {
        return this.scale.length;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (this.scale.length != 1 && this.scale.length != src.getColorModel().getNumComponents() && this.scale.length != src.getColorModel().getNumColorComponents()) {
            throw new IllegalArgumentException("Source image has wrong number of bands for these scaling factors.");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        } else if (src.getHeight() != dst.getHeight() || src.getWidth() != dst.getWidth()) {
            throw new IllegalArgumentException("Source and destination images are different sizes.");
        }
        BufferedImage dst2 = dst;
        if (dst.getColorModel().getColorSpace().getType() != src.getColorModel().getColorSpace().getType()) {
            dst2 = this.createCompatibleDestImage(src, src.getColorModel());
        }
        int numBands = this.scale.length;
        if (this.scale.length == 1) {
            numBands = src.getColorModel().getNumColorComponents();
        }
        boolean[] bands = new boolean[numBands];
        Arrays.fill(bands, true);
        this.filter(src.getRaster(), dst2.getRaster(), bands);
        if (src.getColorModel().hasAlpha() && numBands == src.getColorModel().getNumColorComponents()) {
            dst2.getRaster().setSamples(0, 0, src.getWidth(), src.getHeight(), numBands, src.getRaster().getSamples(0, 0, src.getWidth(), src.getHeight(), numBands, (int[])null));
        }
        if (dst != dst2) {
            new ColorConvertOp(this.hints).filter(dst2, dst);
        }
        return dst;
    }

    public final WritableRaster filter(Raster src, WritableRaster dest) {
        if (this.scale.length != 1 && this.scale.length != src.numBands) {
            throw new IllegalArgumentException("Number of rasters is incompatible with the number of scaling factors provided.");
        }
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        } else {
            if (src.getHeight() != dest.getHeight() || src.getWidth() != dest.getWidth()) {
                throw new IllegalArgumentException("Source and destination rasters are different sizes.");
            }
            if (src.numBands != dest.numBands) {
                throw new IllegalArgumentException("Source and destination rasters are incompatible.");
            }
        }
        boolean[] bands = new boolean[src.getNumBands()];
        Arrays.fill(bands, true);
        return this.filter(src, dest, bands);
    }

    private WritableRaster filter(Raster src, WritableRaster dest, boolean[] bands) {
        int[] values = new int[src.getHeight() * src.getWidth()];
        int[] maxValue = src.getSampleModel().getSampleSize();
        int i = 0;
        while (i < maxValue.length) {
            maxValue[i] = (int)Math.pow(2.0, maxValue[i]) - 1;
            ++i;
        }
        int band = 0;
        while (band < bands.length) {
            if (bands[band]) {
                float offset;
                float scaleFactor;
                values = src.getSamples(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight(), band, values);
                if (this.scale.length == 1) {
                    scaleFactor = this.scale[0];
                    offset = this.offsets[0];
                } else {
                    scaleFactor = this.scale[band];
                    offset = this.offsets[band];
                }
                int i2 = 0;
                while (i2 < values.length) {
                    values[i2] = (int)((float)values[i2] * scaleFactor + offset);
                    if (values[i2] < 0) {
                        values[i2] = 0;
                    }
                    if (values[i2] > maxValue[band]) {
                        values[i2] = maxValue[band];
                    }
                    ++i2;
                }
                dest.setSamples(dest.getMinX(), dest.getMinY(), dest.getWidth(), dest.getHeight(), band, values);
            }
            ++band;
        }
        return dest;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null) {
            return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        }
        return new BufferedImage(dstCM, src.getRaster().createCompatibleWritableRaster(), src.isAlphaPremultiplied(), null);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = (Point2D)src.clone();
        } else {
            dst.setLocation(src);
        }
        return dst;
    }
}

