/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    private static final String SERVICE = "SecretKeyFactory";
    private SecretKeyFactorySpi skfSpi;
    private Provider provider;
    private String algorithm;

    protected SecretKeyFactory(SecretKeyFactorySpi skfSpi, Provider provider, String algorithm) {
        this.skfSpi = skfSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static final SecretKeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return SecretKeyFactory.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static final SecretKeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return SecretKeyFactory.getInstance(algorithm, p);
    }

    public static final SecretKeyFactory getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("SecretKeyFactory algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(SERVICE, algorithm, provider);
            return new SecretKeyFactory((SecretKeyFactorySpi)spi, provider, algorithm);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.skfSpi.engineGenerateSecret(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final KeySpec getKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        return this.skfSpi.engineGetKeySpec(key, keySpec);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        return this.skfSpi.engineTranslateKey(key);
    }
}

